/*
 * Decompiled with CFR 0.152.
 */
package hughes;

import hughes.BinarySearchTree;

public class SplayTree
extends BinarySearchTree {
    private void singleRotationRight(BinarySearchTree.BSTNode S) {
        BinarySearchTree.BSTNode P = (BinarySearchTree.BSTNode)S.parent;
        P.leftChild = S.rightChild;
        if (P.leftChild != null) {
            ((BinarySearchTree.BSTNode)P.leftChild).parent = P;
        }
        S.rightChild = P;
        P.parent = S;
        this.root = S;
        ((BinarySearchTree.BSTNode)this.root).parent = null;
    }

    private void singleRotationLeft(BinarySearchTree.BSTNode S) {
        BinarySearchTree.BSTNode P = (BinarySearchTree.BSTNode)S.parent;
        P.rightChild = S.leftChild;
        if (P.rightChild != null) {
            ((BinarySearchTree.BSTNode)P.rightChild).parent = P;
        }
        S.leftChild = P;
        P.parent = S;
        this.root = S;
        ((BinarySearchTree.BSTNode)this.root).parent = null;
    }

    private void zigZagRight(BinarySearchTree.BSTNode S) {
        BinarySearchTree.BSTNode P = (BinarySearchTree.BSTNode)S.parent;
        BinarySearchTree.BSTNode G = (BinarySearchTree.BSTNode)P.parent;
        BinarySearchTree.BSTNode GG = (BinarySearchTree.BSTNode)G.parent;
        G.leftChild = S.rightChild;
        if (G.leftChild != null) {
            ((BinarySearchTree.BSTNode)G.leftChild).parent = G;
        }
        S.rightChild = G;
        G.parent = S;
        P.rightChild = S.leftChild;
        if (P.rightChild != null) {
            ((BinarySearchTree.BSTNode)P.rightChild).parent = P;
        }
        S.leftChild = P;
        P.parent = S;
        if (GG != null) {
            if (GG.leftChild == G) {
                GG.leftChild = S;
            } else {
                GG.rightChild = S;
            }
        }
        S.parent = GG;
        if (this.root == G) {
            this.root = S;
        }
    }

    private void zigZagLeft(BinarySearchTree.BSTNode S) {
        BinarySearchTree.BSTNode P = (BinarySearchTree.BSTNode)S.parent;
        BinarySearchTree.BSTNode G = (BinarySearchTree.BSTNode)P.parent;
        BinarySearchTree.BSTNode GG = (BinarySearchTree.BSTNode)G.parent;
        G.rightChild = S.leftChild;
        if (G.rightChild != null) {
            ((BinarySearchTree.BSTNode)G.rightChild).parent = G;
        }
        S.leftChild = G;
        G.parent = S;
        P.leftChild = S.rightChild;
        if (P.leftChild != null) {
            ((BinarySearchTree.BSTNode)P.leftChild).parent = P;
        }
        S.rightChild = P;
        P.parent = S;
        if (GG != null) {
            if (GG.leftChild == G) {
                GG.leftChild = S;
            } else {
                GG.rightChild = S;
            }
        }
        S.parent = GG;
        if (this.root == G) {
            this.root = S;
        }
    }

    private void zigZigRight(BinarySearchTree.BSTNode S) {
        BinarySearchTree.BSTNode P = (BinarySearchTree.BSTNode)S.parent;
        BinarySearchTree.BSTNode G = (BinarySearchTree.BSTNode)P.parent;
        BinarySearchTree.BSTNode GG = (BinarySearchTree.BSTNode)G.parent;
        G.leftChild = P.rightChild;
        if (G.leftChild != null) {
            ((BinarySearchTree.BSTNode)G.leftChild).parent = G;
        }
        P.rightChild = G;
        G.parent = P;
        P.leftChild = S.rightChild;
        if (P.leftChild != null) {
            ((BinarySearchTree.BSTNode)P.leftChild).parent = P;
        }
        S.rightChild = P;
        P.parent = S;
        if (GG != null) {
            if (GG.leftChild == G) {
                GG.leftChild = S;
            } else {
                GG.rightChild = S;
            }
        }
        S.parent = GG;
        if (this.root == G) {
            this.root = S;
        }
    }

    private void zigZigLeft(BinarySearchTree.BSTNode S) {
        BinarySearchTree.BSTNode P = (BinarySearchTree.BSTNode)S.parent;
        BinarySearchTree.BSTNode G = (BinarySearchTree.BSTNode)P.parent;
        BinarySearchTree.BSTNode GG = (BinarySearchTree.BSTNode)G.parent;
        G.rightChild = P.leftChild;
        if (G.rightChild != null) {
            ((BinarySearchTree.BSTNode)G.rightChild).parent = G;
        }
        P.leftChild = G;
        G.parent = P;
        P.rightChild = S.leftChild;
        if (P.rightChild != null) {
            ((BinarySearchTree.BSTNode)P.rightChild).parent = P;
        }
        S.leftChild = P;
        P.parent = S;
        if (GG != null) {
            if (GG.leftChild == G) {
                GG.leftChild = S;
            } else {
                GG.rightChild = S;
            }
        }
        S.parent = GG;
        if (this.root == G) {
            this.root = S;
        }
    }

    private void splay(BinarySearchTree.BSTNode S) {
        if (S == null) {
            return;
        }
        while (S != this.root) {
            BinarySearchTree.BSTNode P = (BinarySearchTree.BSTNode)S.parent;
            BinarySearchTree.BSTNode G = (BinarySearchTree.BSTNode)P.parent;
            if (S.parent == this.root) {
                if (((BinarySearchTree.BSTNode)this.root).leftChild == S) {
                    this.singleRotationRight(S);
                    continue;
                }
                this.singleRotationLeft(S);
                continue;
            }
            if (P.leftChild == S) {
                if (G.rightChild == P) {
                    this.zigZagLeft(S);
                    continue;
                }
                this.zigZigRight(S);
                continue;
            }
            if (G.leftChild == P) {
                this.zigZagRight(S);
                continue;
            }
            this.zigZigLeft(S);
        }
    }

    protected BinarySearchTree.BSTNode findHelper(BinarySearchTree.BSTNode current, BinarySearchTree.BSTNode target) {
        if (current == null) {
            return null;
        }
        if (target.compareTo(current) < 0) {
            return this.findHelper((BinarySearchTree.BSTNode)current.leftChild, target);
        }
        if (target.compareTo(current) > 0) {
            return this.findHelper((BinarySearchTree.BSTNode)current.rightChild, target);
        }
        this.splay(current);
        return current;
    }

    public void insert(Comparable newItem) {
        BinarySearchTree.BSTNode newNode = new BinarySearchTree.BSTNode(newItem);
        int oldSize = this.size();
        this.root = this.insertHelper((BinarySearchTree.BSTNode)this.root, newNode);
        this.splay(newNode);
    }

    public void remove(Comparable target) {
        int oldSize = this.size();
        BinarySearchTree.BSTNode found = this.removeHelper((BinarySearchTree.BSTNode)this.root, new BinarySearchTree.BSTNode(target));
        if (this.size() < oldSize) {
            this.splay((BinarySearchTree.BSTNode)found.parent);
        }
    }
}

