% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_many_tweets_json}
\alias{load_many_tweets_json}
\title{load_many_tweets_json}
\usage{
load_many_tweets_json(
  data_dir,
  batch_size = 1000,
  keep_cols = c("text", "possibly_sensitive", "public_metrics", "lang",
    "edit_history_tweet_ids", "attachments", "geo"),
  query = NULL,
  query_error_ok = TRUE
)
}
\arguments{
\item{data_dir}{string that leads to the directory containing JSON files}

\item{batch_size}{integer specifying the number of JSON files
to load per batch. Default: \code{1000}}

\item{keep_cols}{character vector with the names of columns you want to
keep. Set it to \code{NULL} to only retain the required columns.
Default: keep_cols = c("text", "possibly_sensitive", "public_metrics",
"lang", "edit_history_tweet_ids", "attachments", "geo")}

\item{query}{(string) JSON Pointer query passed on to
\link[RcppSimdJson]{fload} (optional). Default: \code{NULL}}

\item{query_error_ok}{(Boolean) stop if \code{query} causes an error. Passed on
to \link[RcppSimdJson]{fload} (optional). Default: \code{FALSE}}
}
\value{
a data.table with all tweets loaded
}
\description{
EXPERIMENTAL. Batched version of \link{load_tweets_json} with control over
retained columns. Not as efficient as \link{load_tweets_json}
but requires less memory.
Wrapper of the function \link[RcppSimdJson]{fload}
}
\details{
Unlike \link{load_tweets_json} this function loads JSON files
in batches and processes each batch before loading the next batch.
You can specify which columns to keep, which in turn requires less memory.
For example, you can decide not to keep the \verb{"text} column, which
requires quite a lot of memory.
}
