% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{Prenucleolus}
\alias{Prenucleolus}
\alias{prenucleolus}
\title{Compute prenucleolus}
\usage{
prenucleolus(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Numeric vector of length n representing the prenucleolus.
}
\description{
Computes the prenucleolus of a TU game with n players.
}
\examples{
library(CoopGame)
prenucleolus(c(1, 1, 1, 2, 3, 4, 5))

\donttest{
#Example 5.5.12 from Peleg/Sudhoelter, p. 96
library(CoopGame)
prenucleolus(c(0,0,0,10,0,0,2))
#Output
#[1]  3  3 -4
#In the above example nucleolus and prenucleolus do not coincide!

library(CoopGame)
prenucleolus(c(0, 0, 0, 0, 5, 5, 8, 9, 10, 8, 13, 15, 16, 17, 21))
# [1] 3.5 4.5 5.5 7.5

#Final example:
#Estate division problem from Babylonian Talmud with E=200,
#see e.g. seminal paper by Aumann & Maschler from 1985 on
#'Game Theoretic Analysis of a Bankruptcy Problem from the Talmud'
library(CoopGame)
v<-bankruptcyGameVector(n=3,d=c(100,200,300),E=200)
prenucleolus(v)
#[1]  50 75 75
#Note that nucleolus and prenucleolus need to coincide for the above game
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 107--132
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
