% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApexGame.R
\name{apexGame}
\alias{apexGame}
\title{Construct an apex game}
\usage{
apexGame(n, apexPlayer)
}
\arguments{
\item{n}{represents the number of players}

\item{apexPlayer}{specifies the number of the apex player}
}
\value{
A list with three elements 
representing the apex game (n, apexPlayer, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified apex game:} \cr
A coalition can only win (and hence obtain the value \code{1}) 
if it \cr
a) contains both the apex player and one additional player \cr
or \cr
b) contains all players except for the apex player. \cr
Any non-winning coalitions obtain the value \code{0}. \cr
Note that apex games are always simple games.
}
\section{Related Functions}{
 
\link{apexGameValue}, \link{apexGameVector}
}

\examples{
#' library(CoopGame)
apexGameVector(n=3,apexPlayer=2)

\donttest{
library(CoopGame)
#Example with four players, apex player is number 3
(vv<-apexGame(n=4,apexPlayer=3))
#$n
#[1] 4

#$apexPlayer
#[1] 4

#$v
# [1] 0 0 0 0 0 1 0 1 0 1 1 1 1 1 1
}

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 164--165
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
