% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DictatorGame.R
\name{dictatorGame}
\alias{dictatorGame}
\title{Construct a dictator game}
\usage{
dictatorGame(n, dictator)
}
\arguments{
\item{n}{represents the number of players}

\item{dictator}{Number of the dictator}
}
\value{
A list with three elements 
representing the dictator game (n, dictator, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified dictator game:} \cr
Any coalitions including the dictator receive coalition 
value \code{1}. All the other coalitions, i.e. each and 
every coalition not containing the dictator, receives 
coalition value \code{0}. \cr
Note that dictator games are always simple games.
}
\section{Related Functions}{
 
\link{dictatorGameValue}, \link{dictatorGameVector}
}

\examples{
library(CoopGame) 
dictatorGame(n=3,dictator=2)

\donttest{
library(CoopGame) 
dictatorGame(n=4,dictator=2)
#Output:
#$n
#[1] 4

#$dictator
#[1] 2

#$v
#[1] 0 1 0 0 1 0 0 1 1 0 1 1 0 1 1
}

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, p. 295

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 764
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
