% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_aohi.R
\name{cc_aohi}
\alias{cc_aohi}
\title{Identify Coordinates in Artificial Hotspot Occurrence Inventory}
\usage{
cc_aohi(
  x,
  lon = "decimalLongitude",
  lat = "decimalLatitude",
  species = "species",
  taxa = c("Aves", "Insecta", "Mammalia", "Plantae"),
  buffer = 10000,
  geod = TRUE,
  value = "clean",
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing geographical coordinates and species names.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimalLongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimalLatitude}.}

\item{species}{character string. The column with the species identity. Only
required if verify = TRUE.}

\item{taxa}{Artificial Hotspot Occurrence Inventory (AHOI) were created based
on four different taxa, birds, insecta, mammalia, and plantae. Users can
choose to keep all, or any specific taxa subset to define the AHOI locations.
Default is to keep all: c("Aves", "Insecta", "Mammalia", "Plantae").}

\item{buffer}{The buffer around each capital coordinate (the centre of the
city), where records should be flagged as problematic. Units depend on
geod. Default = 10 kilometres.}

\item{geod}{logical. If TRUE the radius around each capital is calculated
based on a sphere, buffer is in meters and independent of latitude. If
FALSE the radius is calculated assuming planar coordinates and varies
slightly with latitude. Default = TRUE.
See https://seethedatablog.wordpress.com/ for detail and credits.}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
  containing the records considered correct by the test (\dQuote{clean}) or a
  logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test
  failed/potentially problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags records within Artificial Hotspot Occurrence Inventory.
Poorly geo-referenced occurrence records in biological databases are often
erroneously geo-referenced to highly recurring coordinates that were assessed
by Park et al 2022. See the reference for more details.
}
\note{
See \url{https://ropensci.github.io/CoordinateCleaner/} for more
details and tutorials.
}
\examples{

x <- data.frame(species = letters[1:10], 
                decimalLongitude = c(runif(99, -180, 180), -47.92), 
                decimalLatitude = c(runif(99, -90,90), -15.78))
cc_aohi(x)

}
\references{
Park, D. S., Xie, Y., Thammavong, H. T., Tulaiha, R., & Feng, X.
  (2023). Artificial Hotspot Occurrence Inventory (AHOI). Journal of
  Biogeography, 50, 441–449. \doi{10.1111/jbi.14543}
}
\seealso{
Other Coordinates: 
\code{\link{cc_cap}()},
\code{\link{cc_cen}()},
\code{\link{cc_coun}()},
\code{\link{cc_dupl}()},
\code{\link{cc_equ}()},
\code{\link{cc_gbif}()},
\code{\link{cc_inst}()},
\code{\link{cc_iucn}()},
\code{\link{cc_outl}()},
\code{\link{cc_sea}()},
\code{\link{cc_urb}()},
\code{\link{cc_val}()},
\code{\link{cc_zero}()}
}
\concept{Coordinates}
\keyword{Coordinate}
\keyword{cleaning}
