\name{counterfactual}
\alias{counterfactual}
\alias{QteDistEst}
\alias{BootstrapProcedure}
\alias{InferenceTestingEval}
\alias{TestingEval}
\alias{VarianceEval}
\alias{getquantile}
\alias{DiscreteInference}

\title{
Estimation and Inference Methods for Counterfactual Analysis
}

\description{
Implements the estimation and inference methods for counterfactual analysis described in Chernozhukov, Fernandez-Val and Melly (2013). \code{Counterfactual} reports point estimates, pointwise confidence bands, and simultaneous confidence bands for function-valued quantile effects (QE). It also reports p-values for functional hypotheses such as no effect, constant effect and stochastic dominance. The uniform confidence bands and p-values are obtained by inverting Kolmogorov-Smirnov  (KS) and Cramer-von-Misses-Smirnov (CMS) statistics. The distribution of these statistics is approximated by empirical or weighted bootstrap. We recommend the use of weighted bootstrap when the covariates X include  discrete components with small cell sizes.
}

\usage{
counterfactual(formula, data, weights, na.action = na.exclude, 
  group, treatment =FALSE, decomposition = FALSE, counterfactual_var,
  transformation = FALSE, quantiles = c(1:9)/10,  
  method = "qr", trimming = 0.005, nreg = 100,
  scale_variable, counterfactual_scale_variable, censoring = 0, 
  right = FALSE, nsteps = 3, firstc = 0.1, secondc = 0.05,  
  noboot = FALSE, weightedboot = FALSE, seed = 8, robust = FALSE,  
  reps = 100, alpha = 0.05, first = 0.1, last = 0.9, cons_test = 0, 
  printdeco = TRUE, sepcore = FALSE, ncore = 1) 
}

\arguments{
    
  \item{formula}{
a formula object, with the response Y on the left of a ~ operator, and the covariate terms X, separated by + operators, 
on the right. 
}
  \item{data}{
a data.frame in which to interpret the variables named in the formula, or in the weights argument. 
If this is missing, then the variables in the formula should be on the search list.
 }
  \item{weights}{
vector of observation weights.
}
  \item{na.action}{
 	a function to filter missing data. 
	The default (with \code{na.fail}) is to create an error if any missing values are found. 
	A possible alternative is \code{na.omit}, which deletes observations that contain one or more missing values. 
}
  \item{quantiles}{
 quantile indexes of interest for the QE. It should be a vector of values between 0 and 1 with default \code{c(1:9)/10}.
}
  \item{group}{
 name of a binary variable defining the reference population (value 0) and counterfactual population (value 1).
}
  \item{treatment}{
 logical: if \code{TRUE}, then computes the structure or treatment effect (only useful when \code{group} is specified); if \code{FALSE}, then computes the composition effect.
}
   \item{decomposition}{
 logical: if \code{TRUE}, then computes the structure effect, composition effect and total effect; if \code{FALSE}, then computes the structure effect (only useful when \code{group} is specified, and \code{treatment=TRUE}).
}
 \item{transformation}{
logical: if \code{TRUE}, then the counterfactual distribution of X is generated by transformation of the distribution of X in the reference population.
}
  \item{counterfactual_var}{
selects the values of X in the counterfactual population (only useful when \code{group} is not specified).
}
  \item{method}{
 selects the model to be used to estimate the conditional distribution. The following methods have been implemented:  
 \code{qr} (quantile regression, the default), \code{loc} (location shift), \code{locsca} (location scale shift), \code{cqr} (censored quantile regression), \code{cox} (duration regression), \code{logit} (logit distribution regression), \code{probit} (probit distribution regression), and \code{lpm} (linear probability model).
}
\item{trimming}{
 value between 0 and 0.5 specifying the amount of trimming to avoid tail estimation in \code{qr} method; default is 0.005.
 }
  \item{nreg}{
 sets the number of regressions estimated to approximate the conditional distribution; default is 100.
} 
  \item{scale_variable}{
selects the components of X that affect the scale in the \code{locsca} method.
}
  \item{counterfactual_scale_variable}{
 selects the counterfactual values of the components of X that affect the scale in the \code{locsca} method (only useful when \code{counterfactual_var} is specified).
}
  \item{censoring}{
 variable specifying the censoring point for each observations (only useful when \code{method=cqr}).
}
  \item{right}{
logical: if \code{TRUE}, then indicates that the variable is right-censored;  if \code{TRUE}, then indicates that the variable is left-censored (only useful when \code{method=cqr}).
}
  \item{nsteps}{
selects the number of steps performed in the \code{cqr} method; default and minimum is 3 (only useful when \code{method=cqr}).
}
  \item{firstc}{
 selects the percentage of observations thrown out during the second step in the \code{cqr} method; default is 0.1 (only useful when \code{method=cqr}).
}
  \item{secondc}{
selects the percentage of observations thrown out during the third and further steps of the \code{cqr} method; default is 0.05 (only useful when \code{method=cqr}).
}
  \item{noboot}{
 logical: if \code{TRUE}, then suppresses the bootstrap;  if \code{FALSE}, the default, then runs the bootstrap.
}
  \item{weightedboot}{
 logical: if \code{TRUE}, then implements weighted bootstrap with standard exponential weights;  if \code{FALSE}, the default, then implements empirical bootstrap (only useful when \code{noboot=FALSE}).
}
  \item{seed}{
  sets the seed for the random number generation (only useful when \code{noboot=FALSE}).
  }
  \item{robust}{
logical: if \code{TRUE}, then uses the bootstrap interquartile range to estimate standard errors in the KS and CMS statistics; if \code{FALSE}, the default, then uses the bootstrap standard deviation to estimate standard errors in the KS and CMS statistics (only useful when \code{noboot=FALSE}).
}
  \item{reps}{
  number of bootstrap replications; default is 100 (only useful when \cr \code{noboot=FALSE}).
}
  \item{alpha}{
 a real number between 0 and 1 reflecting the desired significance level for the confidence bands and hypotheses tests (only useful when \code{noboot=FALSE}).
}
  \item{first}{
 sets the lowest quantile that is used for functional inference; default is 0.1 (only useful when \code{noboot=FALSE}).
}
  \item{last}{
 sets the highes quantile that is used for functional inference; default is 0.9 (only useful when \code{noboot=FALSE}).
}
  \item{cons_test}{
adds tests of the null hypothesis that the QEs = \code{cons_test} at all the specified quantiles (only useful when \code{noboot=FALSE}).
}
  \item{printdeco}{
 logical: if \code{FALSE}, then suppresses table of results.
}
  \item{sepcore}{
  logical: if \code{TRUE}, then multiple cores are used for parallel computing.
}
  \item{ncore}{
 number of cores used for parallel computing (only useful when \code{sepcore=TRUE}).
}
}
\details{ 
The populations to construct the observed and counterfactual distributions can be specified in two alternative ways. If the option \code{group} is specified and \code{treatment=FALSE}, then the observed distribution is estimated from the conditional and covariate distributions of \code{group=0}, and the counterfactual distribution is estimated from the conditional distribution of \code{group=0} and the covariate distribution of \code{group=1}. If \code{group} is specified and \code{treatment=TRUE}, then the observed distribution is estimated from the conditional and covariate distributions of \code{group=1}, and the counterfactual distribution is estimated from the conditional distribution of \code{group=0} and the covariate distribution of \code{group=1}. If \code{group} is specified, \code{treatment=TRUE} and \code{decomposition=TRUE}, then all the previous observed and counterfactual distributions are estimated. Alternatively, the option \code{counterfactual_var} can be specified. In this case, the variables specified in the right hand side of \code{formula} contain the covariate values used to estimate the observed distribution and the variables specified in \code{counterfactual_var} contain the covariate values to estimate the counterfactual distribution. Note that \code{counterfactual_var} must contain exactly the same number of variables as in the right hand side of \code{formula} and that the order matters. In addition, if \code{counterfactual_var} is a deterministic transformation of the covariates in the reference  population, then \code{transformation} should be set to \code{TRUE}.

\code{method}:

\code{qr} is the default, selects the method based on the linear quantile regression estimator of Koenker and Bassett (1978). 

\code{loc} selects the linear location shift method. 

\code{locsca} selects the linear location-scale shift method. The logarithm of the variance of the residuals is assumed to be a linear function of the variables given in \code{scale_variable}. 

\code{cqr} selects the method based on the censored linear quantile regression estimator of Chernozhukov and Hong (2002). The variable with the censoring values for each observation must be specified in \code{censoring}. By default, this estimator is a three-steps estimator. The number of steps can be increased by the option \code{nsteps}. 

\code{cox} selects the methob based on the  proportional hazard or duration regression estimator of Cox (1972).  

\code{logit} selects the method based on the distribution regression estimator of Chernozhukov, Fernandez-Val and Melly (2013) with logit link function.

\code{probit} selects the method based on the distribution regression estimator of Chernozhukov, Fernandez-Val and Melly (2013) with probit link function.

\code{lpm} selects the method based on the distribution regression estimator of Chernozhukov, Fernandez-Val and Melly (2013) with linear link function.

We refer the user to Chen, Chernozhukov, Fernandez-Val and Melly (2016) for a more detailed description of the methods.
}



\value{
Return a list of results
\item{quantiles}{quantile indexes of interest for the QE.}

\item{structure_effect}{a vector with the estimated structure effects at the quantile indexes specified with \code{quantiles}. This vector is reported when \code{group} is specified and \code{treatment=TRUE}.}

\item{composition_effect}{a vector with the estimated composition effects at the quantile indexes specified with \code{quantiles}. If \code{group} is specified, then this vector is reported when \code{treatment=FALSE}, or \code{treatment=TRUE} and \code{decomposition=TRUE}.}

\item{total_effect}{a vector with the estimated total effects at the quantile indexes specified with \code{quantiles}. This vector is reported when \code{group} is specified, \code{treatment=TRUE} and \code{decomposition=TRUE}.}

\item{sample_quantile_ref0}{a matrix with 4 columns. The columns contain the point estimates, standard errors, uniform lower end of confidence band, and uniform upper end of confidence band for the quantiles of Y in the observed distribution estimated using sample quantiles at the quantile indexes specified with \code{quantiles}. If \code{group} is specified, then this matrix is reported when \code{treatment=FALSE}, or \cr \code{treatment=TRUE} and \code{decomposition=TRUE}.}

\item{model_quantile_ref0}{a matrix with 4 columns. The columns contain the point estimates, standard errors, uniform lower end of confidence band, and uniform upper end of confidence band for the quantiles of Y in the observed distribution estimated using the conditional model at the quantile indexes specified with \code{quantiles}. If \code{group} is specified, then this matrix is reported when \code{treatment=FALSE}, or \code{treatment=TRUE} and \code{decomposition=TRUE}.}

\item{model_quantile_counter}{a matrix with 4 columns. The columns contain the point estimates, standard errors, uniform lower end of confidence band, and uniform upper end of confidence band for the quantiles of Y in the counterfactual distribution estimated using the conditional model at the quantile indexes specified with \code{quantiles}.}

\item{sample_quantile_ref1}{a matrix with 4 columns. The columns contain the point estimates, standard errors, uniform lower end of confidence band, and uniform upper end of confidence band for the quantiles of Y in the observed distribution of the  population defined by $\code{group=1}$ estimated using sample quantiles at the quantile indexes specified with \code{quantiles}. This matrix is reported when \code{group} is specified and \code{treatment=TRUE}.}

\item{model_quantile_ref1}{a matrix with 4 columns. The columns contain the point estimates, standard errors, uniform lower end of confidence band, and uniform upper end of confidence band for the quantiles of Y in the observed distribution of the population  defined by $\code{group=1}$ estimated using the conditional model at the quantile indexes specified with \code{quantiles}. This matrix is reported when \code{group} is specified and \code{treatment=TRUE}.}

\item{nreg}{number of regressions estimated to approximate the conditional distribution.}

\item{marginal_counterfactual}{a vector with the point estimates for the quantiles of Y in the counterfactual distribution estimated using the conditional model at the quantile indexes specified with \code{quantiles}.}

\item{resSE}{a matrix with 6 columns. The columns contain the point estimates, standard errors, pointwise lower end of confidence band, pointwise upper end of confidence band, uniform lower end of confidence band, and uniform upper end of confidence band for the structure or treatment quantile effect at the quantile indexes specified with \code{quantiles}. This matrix is reported when \code{group} is specified and \code{treatment=TRUE}.}

\item{testSE}{a matrix with 2 columns including the p-values based on the KS and CMS statistics for several functional hypotheses on the structure or treatment effect.  The first row tests the null-hypothesis of correct specification of the conditional model. The second row tests the null
hypothesis that the change in the distribution of the covariates has no effect. The following rows tests the null hypotheses of constant QE, positive QE, and negative QE. An additional row testing the null hypotheses of constant QE (but at a different level than 0) is added if the option \code{cons_test} is specified. This matrix is reported when \code{group} is specified and \code{treatment=TRUE}.
 }


\item{resCE}{a matrix with 6 columns. The columns contain the point estimates, standard errors, pointwise lower end of confidence band, pointwise upper end of confidence band, uniform lower end of confidence band, and uniform upper end of confidence band for the composition quantile effect  at the quantile indexes specified with \code{quantiles}. If \code{group} is specified, then this matrix is reported when \code{treatment=FALSE}, or \code{treatment=TRUE} and  \code{decomposition=TRUE}.}

\item{testCE}{a matrix with 2 columns including the p-values based on the KS and CMS statistics for several functional hypotheses on the composition effect.  The first row tests the null-hypothesis of correct specification of the conditional model. The second row tests the null
hypothesis that the change in the distribution of the covariates has no effect. The following rows tests the null hypotheses of constant QE, positive QE, and negative QE. An additional row testing the null hypotheses of constant QE (but at a different level than 0) is added if the option \code{cons_test} is specified. If \code{group} is specified, then this matrix is reported when \code{treatment=FALSE}, or \code{treatment=TRUE} and  \code{decomposition=TRUE}.
}

\item{resTE}{a matrix with 6 columns. The columns contain the point estimates, standard errors, pointwise lower end of confidence band, pointwise upper end of confidence band, uniform lower end of confidence band, and uniform upper end of confidence band for the total quantile effect  at the quantile indexes specified with \code{quantiles}. This matrix is reported when \code{group} is specified, \code{treatment=TRUE} and \code{decomposition=TRUE}}

\item{testTE}{a matrix with 2 columns including the p-values based on the KS and CMS statistics for several functional hypotheses on the total effect.  The first row tests the null-hypothesis of correct specification of the conditional model. The second row tests the null
hypothesis that the change in the distribution of the covariates has no effect. The following rows tests the null hypotheses of constant QE, positive QE, and negative QE. An additional row testing the null hypotheses of constant QE (but at a different level than 0) is added if the option \code{cons_test} is specified. This matrix is reported when \code{group} is specified, \code{treatment=TRUE} and \code{decomposition=TRUE}.
 }
 
}
\references{

Chen, M., Chernozhukov, V., I. Fernandez-Val, and B. Melly (2016). Counterfactual Analysis in R: A Vignette.

Chernozhukov, V., I. Fernandez-Val, and B. Melly (2013). Inference on Counterfactual Distributions. Econometrica 81(6), 2205-2268.

Chernozhukov, V., and H. Hong (2002). Three-step Censored Quantile Regression and Extramarital Affairs. Journal of the American Statistical Association, 97, 872-881.
        
Cox, D. R. (1972). Regression Models and Life Tables. Journal of the Royal Statistical Society, Ser. B, 34, 187-220.

Koenker, R., and G. Bassett (1978). Regression Quantiles. Econometrica, 46(1), 33-50.
}
\author{
Mingli Chen, Victor Chernozhukov, Ivan Fernandez-Val, Blaise Melly
}


\examples{

#Counterfactual distribution of X constructed by transformation of reference distribution
\dontrun{

data(engel)
attach(engel)
counter_income <- mean(income)+0.75*(income-mean(income))
rqres <- counterfactual(foodexp~income, counterfactual_var=counter_income,
nreg=100, transformation=TRUE, sepcore = TRUE, ncore=2)
}

# Wage decomposition: counterfactual and reference populations correspond to different groups
data(nlsw88)
attach(nlsw88)
lwage <- log(wage)

# method: logit
logitres<-counterfactual(lwage~tenure+ttl_exp+grade, group=union, treatment=TRUE, 
decomposition=TRUE, method="logit", noboot=TRUE, sepcore = TRUE,ncore=2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{optimize}
\keyword{manip}
\keyword{regression}
\keyword{models}
