% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_utils.R
\name{Jacobian}
\alias{Jacobian}
\title{Jacobian matrix for transformation functions}
\usage{
Jacobian(X, a, d, p, fun)
}
\arguments{
\item{X}{vectorized covariance matrix for which the Jacobian matrix is
applied}

\item{a}{vector containing the indices which belong to the diagonal of the
covariance matrix}

\item{d}{dimension of the covariance matrix}

\item{p}{dimension of the vectorized matrix}

\item{fun}{transformation function, that should be used.
\code{\link{subdiagonal_mean_ratio_fct}} or
\code{\link{subdiagonal_mean_ratio_cor}}}
}
\value{
the Jacobian matrix applied for the given vector
}
\description{
A function which calculates the Jacobian matrix for a given
transformation function \code{\link{subdiagonal_mean_ratio_cor}} or
\code{\link{subdiagonal_mean_ratio_fct}}
}
\keyword{internal}
