#' Wastewater data set cleaned from the surveillance branch
#'
#' Data from the DHS of wastewater prevalence in Wisconsin cites
#' 
#' Raw file 'Shareable_Data_wastewater.csv'
#' From zip file attached to 4/21/2022 email from Matthew Schinwald
#'
#' @docType data
#'
#' @usage data("WasteWater_data")
#'
#' @format Rows: 11,084 Columns: 62
#'
#' @keywords datasets
"WasteWater_data"


#' Toy example of full data contains 3 sites and roughly 500 entries (waste and case merged together)
#' 
#'
#' @docType data
#'
#' @usage data("Example_data")
#'
#' @format Rows: 500 Columns: 69
#'
#' @keywords datasets
"Example_data"


#' Case data set from the DHS on 4/21/2022
#'
#' Data from the DHS of positive covid tests in Wisconsin cites
#' 
#' Raw file 'Shareable_Data_cases.csv'
#' From zip file attached to 4/21/2022 email from Matthew Schinwald
#' 
#'
#' @docType data
#'
#' @usage data("Case_data")
#'
#' @format Rows: 33103  Columns: 4
#'
#' @keywords datasets
"Case_data"



#' Madison interceptor Case data set
#'
#' Data from the DHS of positive covid tests for Madison interceptors
#' 
#' Raw file 'MSN_Interceptor_Cases.csv'
#' From email Nathan on 2/4/2022
#' 
#'
#' @docType data
#'
#' @usage data("InterceptorCase_data")
#'
#' @format Rows: 3288   Columns: 5
#'
#' @keywords datasets
"InterceptorCase_data"



#' High frequency Waste data
#'
#' Data from the DHS of  HFG covid wastewater concentration
#' 
#' Raw file 'HFG_data_corrected_w_HF183&CrP_011422.xlsx'
#' Dagmara email Fri 2/25/2022 6:15 PM
#' 
#'
#' @docType data
#'
#' @usage data("HFGWaste_data")
#'
#' @format Rows: 3078   Columns: 18
#'
#' @keywords datasets
"HFGWaste_data"



#' High frequency case data
#'
#' Data from the DHS of positive covid tests for HFG data
#' 
#' Raw file 'HighFreq_CaseData_2021-05-07.csv'
#' From Nathan on 5/26/2021
#' 
#'
#' @docType data
#'
#' @usage data("HFGCase_data")
#'
#' @format Rows: 788   Columns: 6
#'
#' @keywords datasets
"HFGCase_data"


#' City Population data
#'
#' dataframe containing info about each Wisconsin population info
#'
#' 
#'
#' @docType data
#'
#' @usage data("HFGCase_data")
#'
#' @format Rows: 89   Columns: 2
#'
#' @keywords datasets
"Pop_data"


#' Covariants data
#'
#' dataframe containing info about the proportion of each COVID-19 variant
#' every 2 weeks. This data is from 
#' https://github.com/hodcroftlab/covariants/tree/master
#' 
#'
#' @docType data
#'
#' @usage data("Covariants_data")
#'
#' @format Rows: 69   Columns: 33
#'
#' @keywords datasets
"Covariants_data"


#' auxiliary data
#'
#' 
#'
#' @docType data
#'
#' @usage data("Aux_info_data")
#'
#' @format Rows: 999   Columns: 17
#'
#' @keywords datasets
"Aux_info_data"
