% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.Model.R
\name{Model}
\alias{Model}
\title{Stores a previously trained M.L. model.}
\description{
Encapsulates and handles all the information and operations
associated with a M.L. model.
}
\seealso{
\code{\link{D2MCS}}, \code{\link{TrainFunction}}
}
\keyword{internal}
\keyword{misc}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Model-new}{\code{Model$new()}}
\item \href{#method-Model-isTrained}{\code{Model$isTrained()}}
\item \href{#method-Model-getDir}{\code{Model$getDir()}}
\item \href{#method-Model-getName}{\code{Model$getName()}}
\item \href{#method-Model-getFamily}{\code{Model$getFamily()}}
\item \href{#method-Model-getDescription}{\code{Model$getDescription()}}
\item \href{#method-Model-train}{\code{Model$train()}}
\item \href{#method-Model-getTrainedModel}{\code{Model$getTrainedModel()}}
\item \href{#method-Model-getExecutionTime}{\code{Model$getExecutionTime()}}
\item \href{#method-Model-getPerformance}{\code{Model$getPerformance()}}
\item \href{#method-Model-getConfiguration}{\code{Model$getConfiguration()}}
\item \href{#method-Model-save}{\code{Model$save()}}
\item \href{#method-Model-remove}{\code{Model$remove()}}
\item \href{#method-Model-clone}{\code{Model$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-new"></a>}}
\if{latex}{\out{\hypertarget{method-Model-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$new(dir.path, model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir.path}}{The location were the executed models will be saved.}

\item{\code{model}}{A \code{\link{Model}} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-isTrained"></a>}}
\if{latex}{\out{\hypertarget{method-Model-isTrained}{}}}
\subsection{Method \code{isTrained()}}{
The function is used to determine is the model has been
already trained.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$isTrained()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{logical} value. \link{TRUE} if the model
has been trained and \link{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getDir"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getDir}{}}}
\subsection{Method \code{getDir()}}{
The function returns the location path of the specific
model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getDir()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector specifying the location of the
model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getName"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getName}{}}}
\subsection{Method \code{getName()}}{
The function is used to obtain the name of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector with the name of the model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getFamily"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getFamily}{}}}
\subsection{Method \code{getFamily()}}{
The function gets the family of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getFamily()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector representing the family of the ML
model.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getDescription"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getDescription}{}}}
\subsection{Method \code{getDescription()}}{
The function allows obtaining the description associated
with an specific ML model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getDescription()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector with the model description.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-train"></a>}}
\if{latex}{\out{\hypertarget{method-Model-train}{}}}
\subsection{Method \code{train()}}{
The function is responsible of performing model training
operation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$train(train.set, fitting, trFunction, metric, logs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{train.set}}{A \link{data.frame} with the data used for training the
model.}

\item{\code{fitting}}{The model fitting formula. Must inherit from
\code{\link{GenericModelFit}} class.}

\item{\code{trFunction}}{An object inherited from \code{\link{TrainFunction}}
used to define how the training acts.}

\item{\code{metric}}{A \link{character} vector containing the metrics used to
optimized model parameters.}

\item{\code{logs}}{A \link{character} vector containing the path to store the
error logs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getTrainedModel"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getTrainedModel}{}}}
\subsection{Method \code{getTrainedModel()}}{
The function allows obtaining the trained model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getTrainedModel()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link[caret]{train}} class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getExecutionTime"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getExecutionTime}{}}}
\subsection{Method \code{getExecutionTime()}}{
The function is used to compute the time taken to
perform training operation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getExecutionTime()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} vector with length 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getPerformance"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getPerformance}{}}}
\subsection{Method \code{getPerformance()}}{
The function obtains the performance achieved by the model
during training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getPerformance(metric = private$metric)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric}}{A \link{character} used to specify the measure used to
compute the performance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} value with the performance achieved.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-getConfiguration"></a>}}
\if{latex}{\out{\hypertarget{method-Model-getConfiguration}{}}}
\subsection{Method \code{getConfiguration()}}{
The function is used to get the configuration parameters
achieved by the ML model after the training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getConfiguration()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{list} object with the configuration parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-save"></a>}}
\if{latex}{\out{\hypertarget{method-Model-save}{}}}
\subsection{Method \code{save()}}{
The function is responsible of saving the model to disc into
a RDS file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$save(replace = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{replace}}{A \link{logical} value used to determine if model should
be resaved. \link{TRUE} forces to replace previous saved model while
\link{FALSE} keeps unchanged the previous model.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Model-remove}{}}}
\subsection{Method \code{remove()}}{
The function is used to delete a model from disc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$remove()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Model-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Model-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
