% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskFiles.R
\name{jpegReport}
\alias{jpegReport}
\title{Graphics devices for \code{JPEG} format bitmap files.}
\usage{
jpegReport(
  task,
  type,
  ext = "jpg",
  subdir = NULL,
  dirCreate = TRUE,
  dim = c(500, 500),
  width = NULL,
  height = NULL,
  ...
)
}
\arguments{
\item{task}{Object of class \code{\link{D4TAlinkTask}}, as created by \code{\link{initTask}}.}

\item{type}{character string, one of \code{"Xlib"} or \code{"quartz"}
    (some macOS builds) or \code{"cairo"}.  The latter will only be
    available if the system was compiled with support for cairo --
    otherwise \code{"Xlib"} will be used.  The default is set by
    \code{\link{getOption}("bitmapType")} -- the \sQuote{out of the box}
    default is \code{"quartz"} or \code{"cairo"} where available,
    otherwise \code{"Xlib"}.}

\item{ext}{Filename extension.}

\item{subdir}{(optional) Subdirectory.}

\item{dirCreate}{Logical, if TRUE (by default) the directory is created.}

\item{dim}{device height and width in \code{px}.}

\item{width}{device height in \code{px}.}

\item{height}{device height in \code{px}.}

\item{...}{
  Arguments passed on to \code{\link[grDevices:png]{grDevices::jpeg}}
  \describe{
    \item{\code{filename}}{the output file path.
    The page number is substituted if a C integer format is included in
    the character string, as in the default.  (Depending on the platform,
    the result should be less
    than \code{PATH_MAX} characters long, and may be truncated if not.
    See \code{\link[grDevices]{postscript}} for further details.)  Tilde expansion
    is performed where supported by the platform.  An input with
    a marked encoding is converted to the native encoding on an error is
    given.}
    \item{\code{units}}{The units in which \code{height} and \code{width} are
    given.  Can be \code{px} (pixels, the default), \code{in} (inches),
    \code{cm} or \code{mm}.}
    \item{\code{pointsize}}{the default pointsize of plotted text, interpreted as
    big points (1/72 inch) at \code{res} ppi.}
    \item{\code{bg}}{the initial background colour: can be overridden by setting
    par("bg").}
    \item{\code{quality}}{the \sQuote{quality} of the JPEG image, as a
    percentage.  Smaller values will give more compression but also more
    degradation of the image.}
    \item{\code{res}}{The nominal resolution in ppi which will be recorded in the
    bitmap file, if a positive integer.  Also used for \code{units}
    other than the default, and to convert points to pixels.}
    \item{\code{antialias}}{for \code{type = "cairo"}, giving the type of
    anti-aliasing (if any) to be used for fonts and lines (but not
    fills). See \code{\link[grDevices]{X11}}.  The default is set by
    \code{\link[grDevices]{X11.options}}.  Also for \code{type = "quartz"}, where
    antialiasing is used unless \code{antialias = "none"}.}
  }}
}
\value{
the file name invisibly.
}
\description{
Graphics devices for \code{JPEG} format bitmap files.
}
