% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pars.R
\name{are_trait_pars}
\alias{are_trait_pars}
\title{Test if list has trait state parameters}
\usage{
are_trait_pars(trait_pars)
}
\arguments{
\item{trait_pars}{A named list containing diversification rates considering
two trait states created by \code{\link{create_trait_pars}}:
\itemize{
  \item{[1]:A numeric with the per capita transition rate with state1}
  \item{[2]:A numeric with the per capita immigration rate with state2}
  \item{[3]:A numeric with the per capita extinction rate with state2}
  \item{[4]:A numeric with the per capita anagenesis rate with state2}
  \item{[5]:A numeric with the per capita cladogenesis rate with state2}
  \item{[6]:A numeric with the per capita transition rate with state2}
  \item{[7]:A numeric with the number of species with trait state 2 on
   mainland}
}}
}
\value{
Boolean that indicates if list conforms to expected area parameters
as created by \link{create_trait_pars}
}
\description{
Test if list has trait state parameters
}
\examples{
testit::assert(DAISIE:::are_trait_pars(
  create_trait_pars(
    trans_rate = 0.5,
    immig_rate2 = 0.1,
    ext_rate2 = 0.2,
    ana_rate2 = 0.3,
    clado_rate2 = 0.4,
    trans_rate2 = 0.5,
    M2 = 1000)) == TRUE)
}
\keyword{internal}
