% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_tidymodels.R
\name{explain_tidymodels}
\alias{explain_tidymodels}
\title{Create explainer from your tidymodels workflow.}
\usage{
explain_tidymodels(
  model,
  data = NULL,
  y = NULL,
  weights = NULL,
  predict_function = NULL,
  predict_function_target_column = NULL,
  residual_function = NULL,
  ...,
  label = NULL,
  verbose = TRUE,
  precalculate = TRUE,
  colorize = TRUE,
  model_info = NULL,
  type = NULL
)
}
\arguments{
\item{model}{object - a fitted workflow created with \code{mlr3}.}

\item{data}{data.frame or matrix - data that was used for fitting. Data should be passed without target column (this shall be provided as the \code{y} argument). NOTE: If target variable is present in the \code{data}, some of the functionalities my not work properly. Tibble will be converted into data.frame}

\item{y}{numeric vector with outputs / scores. If provided then it shall have the same size as \code{data}}

\item{weights}{numeric vector with sampling weights. By default it's \code{NULL}. If provided then it shall have the same length as \code{data}}

\item{predict_function}{function that takes two arguments: model and new data and returns numeric vector with predictions}

\item{predict_function_target_column}{Character or numeric containing either column name or column number in the model prediction object of the class that should be considered as positive (ie. the class that is associated with probability 1). If NULL, the second column of the output will be taken for binary classification. For a multiclass classification setting that parameter cause switch to binary classification mode with 1 vs others probabilities.}

\item{residual_function}{function that takes three arguments: model, data and response vector y. It should return a numeric vector with model residuals for given data. If not provided, response residuals (\eqn{y-\hat{y}}) are calculated.}

\item{...}{other parameters}

\item{label}{character - the name of the model. By default it's extracted from the 'class' attribute of the model}

\item{verbose}{if TRUE (default) then diagnostic messages will be printed.}

\item{precalculate}{if TRUE (default) then 'predicted_values' and 'residuals' are calculated when explainer is created.}

\item{colorize}{if TRUE (default) then \code{WARNINGS}, \code{ERRORS} and \code{NOTES} are colorized. Will work only in the R console.}

\item{model_info}{a named list (\code{package}, \code{version}, \code{type}) containg information about model. If \code{NULL}, \code{DALEX} will seek for information on it's own.}

\item{type}{type of a model, either \code{classification} or \code{regression}. If not specified then \code{type} will be extracted from \code{model_info}.}
}
\value{
explainer object (\code{\link[DALEX]{explain}}) ready to work with DALEX
}
\description{
DALEX is designed to work with various black-box models like tree ensembles, linear models, neural networks etc.
Unfortunately R packages that create such models are very inconsistent. Different tools use different interfaces to train, validate and use models.
One of those tools, which is one of the most popular one is tidymodels package. We would like to present dedicated explain function for it.
}
\examples{
library("DALEXtra")
library("tidymodels")
library("recipes")
data <- titanic_imputed
data$survived <- as.factor(data$survived)
rec <- recipe(survived ~ ., data = data) \%>\%
       step_normalize(fare)
model <- decision_tree(tree_depth = 25) \%>\%
         set_engine("rpart") \%>\%
         set_mode("classification")

wflow <- workflow() \%>\%
         add_recipe(rec) \%>\%
         add_model(model)


model_fitted <- wflow \%>\%
                fit(data = data)

explain_tidymodels(model_fitted, data = titanic_imputed, y = titanic_imputed$survived)


}
