% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbExecute}
\alias{dbExecute}
\title{Execute an update statement, query number of rows affected, and then close result set}
\usage{
dbExecute(conn, statement, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{statement}{a character vector of length 1 containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
The number of rows affected by the \code{statement}
}
\description{
\code{dbExecute} comes with a default implementation
(which should work with most backends) that calls
\code{\link{dbSendStatement}}, then \code{\link{dbGetRowsAffected}}, ensuring that
the result is always free-d by \code{\link{dbClearResult}}.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "cars", head(cars, 3))
dbReadTable(con, "cars")   # there are 3 rows
dbExecute(con,
  "INSERT INTO cars (speed, dist) VALUES (1, 1), (2, 2), (3, 3);")
dbReadTable(con, "cars")   # there are now 6 rows

dbDisconnect(con)
}
\seealso{
For queries: \code{\link{dbSendQuery}} and \code{\link{dbGetQuery}}.

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}
}

