% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbListObjects}
\alias{dbListObjects}
\title{List remote objects}
\usage{
dbListObjects(conn, prefix = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{prefix}{A fully qualified path in the database's namespace, or \code{NULL}.
will be passed to \code{\link[=dbUnquoteIdentifier]{dbUnquoteIdentifier()}}.
If given the method will return all objects accessible through this prefix.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbListObjects()}
returns a data frame
with columns
\code{table} and \code{is_prefix} (in that order),
optionally with other columns with a dot (\code{.}) prefix.
The \code{table} column is of type list.
Each object in this list is suitable for use as argument in \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
The \code{is_prefix} column is a logical.
This data frame contains one row for each object (schema, table
and view)
accessible from the prefix (if passed) or from the global namespace
(if prefix is omitted).
Tables added with \code{\link[=dbWriteTable]{dbWriteTable()}}
are part of the data frame,
including temporary objects if supported by the database.
As soon a table is removed from the database,
it is also removed from the data frame of database objects.

The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
An error is raised when calling this method for a closed
or invalid connection.
}
\description{
Returns the names of remote objects accessible through this connection
as a data frame.
This should include temporary objects, but not all database backends
(in particular \pkg{RMariaDB} and \pkg{RMySQL}) support this.
Compared to \code{\link[=dbListTables]{dbListTables()}}, this method also enumerates tables and views
in schemas, and returns fully qualified identifiers to access these objects.
This allows exploration of all database objects available to the current
user, including those that can only be accessed by giving the full
namespace.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbListObjects")}
}
\section{Additional arguments}{


TBD: \code{temporary = NA}

This must be provided as named argument.
See the "Specification" section for details on their usage.

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbListObjects(con)
dbWriteTable(con, "mtcars", mtcars)
dbListObjects(con)

dbDisconnect(con)
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbReadTable}},
  \code{\link{dbRemoveTable}}, \code{\link{dbSendQuery}},
  \code{\link{dbSendStatement}}, \code{\link{dbWriteTable}}
}
\concept{DBIConnection generics}
