% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbListFields.R
\name{dbListFields}
\alias{dbListFields}
\title{List field names of a remote table}
\usage{
dbListFields(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[=Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[=SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbListFields()}
returns a character vector
that enumerates all fields
in the table in the correct order.
This also works for temporary tables if supported by the database.
The returned names are suitable for quoting with \code{dbQuoteIdentifier()}.
}
\description{
Returns the field names of a remote table as a character vector.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbListFields")}
}
\section{Failure modes}{


If the table does not exist, an error is raised.
Invalid types for the \code{name} argument
(e.g., \code{character} of length not equal to one,
or numeric)
lead to an error.
An error is also raised when calling this method for a closed
or invalid connection.

}

\section{Specification}{



The \code{name} argument can be
\itemize{
\item a string
\item the return value of \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
\item a value from the \code{table} column from the return value of
\code{\link[=dbListObjects]{dbListObjects()}} where \code{is_prefix} is \code{FALSE}
}

A column named \code{row_names} is treated like any other column.

}

\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
dbListFields(con, "mtcars")

dbDisconnect(con)
}
\seealso{
\code{\link[=dbColumnInfo]{dbColumnInfo()}} to get the type of the fields.

Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbCreateTable}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbReadTable}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendStatement}()},
\code{\link{dbWriteTable}()}
}
\concept{DBIConnection generics}
