% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-create-table.R
\docType{data}
\name{spec_sql_create_table}
\alias{spec_sql_create_table}
\title{spec_sql_create_table}
\value{
\code{dbCreateTable()} returns \code{TRUE}, invisibly.
}
\description{
spec_sql_create_table
}
\section{Failure modes}{

If the table exists, an error is raised; the remote table remains unchanged.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}} or
if this results in a non-scalar.
Invalid values for the \code{row.names} and \code{temporary} arguments
(non-scalars,
unsupported data types,
\code{NA},
incompatible values,
duplicate names)
also raise an error.
}

\section{Additional arguments}{

The following arguments are not part of the \code{dbCreateTable()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{temporary} (default: \code{FALSE})
}

They must be provided as named arguments.
See the "Specification" and "Value" sections for details on their usage.
}

\section{Specification}{

The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbCreateTable()} will do the quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}: no more quoting is done
}

The \code{value} argument can be:
\itemize{
\item a data frame,
\item a named list of SQL types
}

If the \code{temporary} argument is \code{TRUE}, the table is not available in a
second connection and is gone after reconnecting.
Not all backends support this argument.
A regular, non-temporary table is visible in a second connection,
in a pre-existing connection,
and after reconnecting to the database.

SQL keywords can be used freely in table names, column names, and data.
Quotes, commas, and spaces can also be used  for table names and column names,
if the database supports non-syntactic identifiers.

The \code{row.names} argument must be missing
or \code{NULL}, the default value.
All other values for the \code{row.names} argument
(in particular \code{TRUE},
\code{NA},
and a string)
raise an error.
}

\seealso{
Other sql specifications: 
\code{\link{spec_sql_append_table}},
\code{\link{spec_sql_exists_table}},
\code{\link{spec_sql_list_fields}},
\code{\link{spec_sql_list_objects}},
\code{\link{spec_sql_list_tables}},
\code{\link{spec_sql_quote_identifier}},
\code{\link{spec_sql_quote_literal}},
\code{\link{spec_sql_quote_string}},
\code{\link{spec_sql_read_table}},
\code{\link{spec_sql_remove_table}},
\code{\link{spec_sql_unquote_identifier}},
\code{\link{spec_sql_write_table}}
}
\concept{sql specifications}
