\name{Kkronm}
\alias{Kkronm}
\title{The product of Kronecker Product of some Arrays}
\usage{
Kkronm(m = 3, nu = 0, h = 0, overlap = TRUE, K = NULL)
}
\arguments{
  \item{m}{a positive integer indicating the size of the window for the polinomial fit.}
  \item{nu}{a non-negative integer denoting the degree of the polinomial fit applied on the integrated series.}
  \item{h}{an integer indicating the lag.}
  \item{overlap}{logical: if true (the default), overlapping boxes are used for calculations. Otherwise, non-overlapping boxes are applied.}
  \item{K}{optional: the matrix defined by \eqn{K = J'QJ}. This is used to  calculate \eqn{K* = (Jm \%x\%  J*)'(Q \%x\%  Q)(Jm \%x\%  J*)}. For details see (19) in Prass and Pumi (2019). If this matrix is provided \eqn{mu} is ignored.}
}
\value{
  an \eqn{(m+1)[(m+1)*(h+1) - m*h*s]} by \eqn{(m+1)[(m+1)*(h+1) - m*h*s]} matrix, where \eqn{s = 1} if overlap = TRUE and \eqn{s = 0}, otherwise. This matrix corresponds to equation (19) in Prass and Pumi (2019).
}
\description{
This is an auxiliary function and requires some context to be used adequadely. It computes equation (19) in Prass and Pumi (2019), returning a square matrix defined by \deqn{K* = (Jm \%x\%  J*)'(Q \%x\%  Q)(Jm \%x\%  J*)} where:
\itemize{
\item \eqn{J} is an \eqn{(m+1)*(h+1) - m*h*s} by \eqn{(m+1)*(h+1) - m*h*s} lower triangular matrix with all non-zero entries equal to one,  with \eqn{s = 1} if overlap = TRUE and \eqn{s = 0}, otherwise;

\item \eqn{Jm} corresponds to the first \eqn{m+1} rows and columns of \eqn{J};

\item \eqn{J*} corresponds to the last \eqn{m+1} rows of \eqn{J};

\item \eqn{Q = I-P}, where \eqn{P} is the \eqn{m+1} by \eqn{m+1} projection matrix into the subspace generated by degree \eqn{nu+1} polynomials.
}
}
\examples{
m = 3
h = 1
J = Jn(n = m+1+h)
Q = Qm(m = m, nu = 0)

# using K
K = Km(J = J[1:(m+1),1:(m+1)], Q = Q)
Kkron0 = Kkronm(K = K, h = h)

# using m and nu
Kkron = Kkronm(m = m, nu = 0, h = h)

# using  kronecker product from R
K = Km(J = J[1:(m+1),1:(m+1)], Q = Q)
Kh = rbind(matrix(0, nrow = h, ncol = m+1+h),
           cbind(matrix(0, nrow = m+1, ncol = h), K))
KkronR = K \%x\% Kh

# using  the definition K* = (Jm \%x\%  J)'(Q \%x\%  Q)(Jm \%x\%  J)
J_m = J[1:(m+1),1:(m+1)]
J_h = J[(h+1):(m+1+h),1:(m+1+h)]
KkronD = t(J_m \%x\%  J_h)\%*\%(Q \%x\%  Q)\%*\%(J_m \%x\%  J_h)


# comparing the results
sum(abs(Kkron0 - Kkron))
sum(abs(Kkron0 - KkronR))
sum(abs(Kkron0 - KkronD))  # difference due to rounding error

# Function Kkronm is computationaly faster than a pure implementation in R:

m = 100
h = 1
J = Jn(n = m+1)
Q = Qm(m = m, nu = 0)

# using Kkronm
t1 = proc.time()
Kkron = Kkronm(m = m, nu = 0, h = 1)
t2 = proc.time()
# elapsed time:
t2-t1

# Pure R implementation:
K = Km(J = J, Q = Q)
Kh = rbind(matrix(0, nrow = h, ncol = m+1+h),
           cbind(matrix(0, nrow = m+1, ncol = h), K))
t3 = proc.time()
KkronR = K \%x\% Kh
t4 = proc.time()
# elapsed time
t4-t3


}
\references{Prass, T.S. and Pumi, G. (2019). On the behavior of the DFA and DCCA in trend-stationary
processes <arXiv:1910.10589>.}
\author{Taiane Schaedler Prass}
\seealso{\code{\link{Jn}} which creates the matrix \eqn{J}, \code{\link{Qm}} which creates \eqn{Q} and \code{\link{Km}} which creates \eqn{K}.}
