% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_init_mv.R
\name{means_mv}
\alias{means_mv}
\title{means_mv: Part of DCEM package.}
\usage{
means_mv(data, num_means)
}
\arguments{
\item{data}{(matrix): The dataset provided by the user (converted to matrix format).}

\item{num_means}{(numeric): The number of means (meu).}
}
\value{
A matrix containing the randomly selected samples from the dataset. The initial
means will be updated during the iterations of the algorithm.
}
\description{
Initialize the mean(s) for the Gaussian(s) by randomly selecting
the samples from the dataset.
}
\examples{
# Generate random samples from a multivariate distribution.
sample_data = MASS::mvrnorm(n=10, rep(10,5), Sigma = diag(5))

# Get the mean(s) from the data
means_mv(sample_data, num_means=2)

}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic

This work was partially supported by NCI Grant 1R01CA213466-01.
}
