% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCS_Methods.R
\name{summary.dcs}
\alias{summary.dcs}
\title{Summarizing Results from Double Conditional Smoothing}
\usage{
\method{summary}{dcs}(object, ...)
}
\arguments{
\item{object}{an object of class "dcs", usually, a result of a call to 
\code{\link{dcs}}.}

\item{...}{Additional arguments passed to the \code{summary.dcs} function.}
}
\value{
The function \code{summary.dcs} returns an object of class 
 \code{summary_dcs} including \tabular{ll}{
 \code{h_opt} \tab estimated optimal bandwidth from the IPI-procedure. \cr
 \code{c_f} \tab estimated variance factor. \cr
 \code{iterations} \tab number of iterations of the IPI-procedure. \cr
 \code{time_used} \tab time spend searching for optimal bandwidths (not 
  overall runtime of the function). \cr
 \code{qarma} \tab optional return, if method \code{"qarma"} is chosen for 
  estimation of the variance factor. Omitted, if \code{"iid"} is used. \cr
 \code{dcs_options} \tab an object of class \code{cds_options} containing the
  initial options of the dcs procedure. \cr
}
}
\description{
\code{summary} method for class \code{"dcs"}
}
\section{Details}{

\code{summary.dcs} strips an object of class \code{"dcs"} from all large
 matrices (\code{Y}, \code{X}, \code{T}, \code{M}, \code{R}), allowing
 for easier handling of meta-statistics of the bandwidth selection procedure.

 \code{print.summary_dcs} returns a list of summary statistics
 from the dcs procedure. The output depends on the use of the \code{dcs}-
 function. If automatic bandwidth selection is chosen, \code{summary.dcs}
 prints detailed statistics of the type of regression, the estimated 
 bandwidths \code{h_x}, \code{h_t}, the variance coefficient \code{c_f} and 
 performance statistics such as the number of iterations of the IPI-algorithm 
 and the time used for bandwidth selection.

 The method used for estimation of the variance coefficient is printed and 
 the results of an QARMA-estimation, if available.

 If bandwidths are supplied to \code{dcs}, \code{summary.dcs} only prints
 the given bandwidths.
}

\examples{
y <- y.norm1 + matrix(rnorm(101^2), nrow = 101, ncol = 101)
dcs_object <- dcs(y)
summary(dcs_object)

}
