% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proccess_and_plot_DEET_enrich.R
\name{proccess_and_plot_DEET_enrich}
\alias{proccess_and_plot_DEET_enrich}
\title{proccess_and_plot_DEET_enrich}
\usage{
proccess_and_plot_DEET_enrich(
  DEET_output,
  colour_barplot = "Source",
  width = 8,
  text_angle = 0,
  horizontal = F,
  topn = 5,
  ol_size = 1,
  exclude_domain = "",
  cluster_order = NULL,
  colors = "Set2"
)
}
\arguments{
\item{DEET_output}{Direct output of the DEET_enrich function.
A list with all of the same names as DEET_output.}

\item{colour_barplot}{Pick dotplot or barplot colours.
It can be NULL, in which all bars are the same or it can
be a (case sensitive) column within the metadata. Defaults
to "source".}

\item{width}{The number of inches in the barplot or dotplot.}

\item{text_angle}{The angle of the enriched studies.}

\item{horizontal}{Whether the output barplot is vertical or horizontal}

\item{topn}{the top number of studies (by p-value) to be plotted.}

\item{ol_size}{the minimum number of overlapping genes (or paths) in an enriched study.}

\item{exclude_domain}{Exclude studies enriched based on DEGs, Paths, or TF if
the user happened to aggregate the results into a single DF, generally unused.}

\item{cluster_order}{Factor to group studies based on the researchers custom annotation.}

\item{colors}{Type of color pallete to input into 'scale_fill_brewer' of ggplot.}
}
\value{
Named list where each element is a ggplot object plotting the output of
the enrichment tests within DEET. The final element is the output of ActivePathways
(in DEET) that is directly compatible with the DEET_enrichment_barplot function.

\itemize{
  \item DEET_DotPlot - ggplot object of Dotplot of enrichment of enrichment of DEET studies
  based on DE, BP, and TF information. Only plotted if 2/3 levels contain
  at least one significant study.
  \item Pathway_barplot - ggplot object of Barplot of standard gene set enrichment based on
  gene ontology and TFs. Only plotted if there is at least one enriched
  significant pathway/TF.
  \item individual_barplot - ggplot object of Barplot of the top enriched pathways or studies
  (depending on the input list).Barplot is only generated if each list has at least one pathway (or study)
  is enriched.
  \item DEET_output_forplotting - output of Activepathways with "domain", "overlap.size", and "p.value"
  columns added to be compatible with the DEET_enrichment_barplot function.

}
}
\description{
Generates barplots and dotplots based on the output of
the DEET_enrich function.
}
\examples{

data("example_DEET_enrich_input")
data("DEET_example_data")
DEET_out <- DEET_enrich(example_DEET_enrich_input, DEET_dataset = DEET_example_data)
plotting_example <- proccess_and_plot_DEET_enrich(DEET_out, text_angle = 45,
horizontal = TRUE, topn=4)


}
\author{
Dustin Sokolowski, Hauyun Hou PhD
}
