% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DE_expr_plots.R
\name{de_density_plot}
\alias{de_density_plot}
\title{Visualize density plots of fold-change or significance values for aggregated data sets.}
\usage{
de_density_plot(res_list, filename = "de_density_plot.pdf",
  type = "pval", method = "union", returnData = FALSE)
}
\arguments{
\item{res_list}{A list of DESeq result sets. Results can be calculated individually using DESeq's results() function.
Lists of results can be created by creating a list(result1, result2 ... result_N).}

\item{filename}{Filename for output plot.  Valid extensions are ".pdf" and ".png".
File generation can be turned off using set_output_mode("screen").
Output will be written to the /DE/density_plots/ directory.}

\item{type}{The type of data to be displayed in this plot.
Valid selections are "lfc" (log2foldChange) and "pval".}

\item{method}{The method for computing overlaying results.  Valid selections are "union" or "intersection".
Union merges data for all result sets for genes that are differentially expressed in at least 1 result set.
Intersection merges data for genes that only are differentially expressed in all result sets provided.}

\item{returnData}{Boolean.  Determines if this visualization should return data used to generate the visualization. Default=FALSE.}
}
\value{
If returnData is true, this function will return a data frame for aggregated differentially expressed genes
containing gene names and log2 fold-change or adjusted p-values relative to the experimental control condition.
}
\description{
This function plots log2 fold-change or adjusted p-values for all differentially expressed genes for each contrast in
a result set.  Data aggregation across a series of result sets entails that not every gene in an aggregated data
set will necessarily be differentially expressed, depending on the aggregation method.  For instance, a gene that is differentially
expressed in a day1 contrast that is not significant at day2 will be included in a union based aggregation of genes for
day1 and day2.  Visualizing the density of fold-change or p-values can reveal to what extent aggregation was consistent
across conditions and can inform decision making in data aggregation.
}
\examples{
\dontrun{

 #This example assumes an experimenal design of ~Condition_Time.

#Prepare a result list.
res.day1 <- results(dds, contrast=c("Condition_Time", "day1_disease", "day1_control"))
res.day2 <- results(dds, contrast=c("Condition_Time", "day2_disease", "day2_control"))
res.day3 <- results(dds, contrast=c("Condition_Time", "day3_disease", "day3_control"))
myResList <- list(res.day1, res.day2, res.day3)

/*
 * Aggregate data for all contrasts in the result list using union aggregation.
 * Display the density plot of p-values for the aggregated data.
 */
de_density_plot(res_list=myResList, filename="DE_density_union_pval.pdf",
                 type="pval", method="union", returnData=FALSE)

/*
 * Aggregate data for all contrasts in the result list using intersection aggregation.
 * Display the density plot of log fold-change values for the aggregated data.
 * Store the aggregate data as DE_lfc_intersect_df.
 */
DE_lfc_intersect_df <- de_density_plot(res_list=myResList,
                                        filename="DE_density_union_pval.pdf",
                                        type="lfc", method="intersection",
                                        returnData=TRUE)

}
}
\keyword{DE}
\keyword{aggregate}
\keyword{density}
\keyword{fold-change}
\keyword{p-value}
\keyword{visualization}
