% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topTable.merge.R
\name{topTable.merge}
\alias{topTable.merge}
\title{Merge specified topTable df cols}
\usage{
topTable.merge(
  contrastList,
  colNames = c("logFC", "AveExpr", "P.Value", "adj.P.Val"),
  digits = c(2, 2, 4, 3)
)
}
\arguments{
\item{contrastList}{A named list of topTable data.frames which all have the same colnames and same row counts.
The dataframes in the list should have rownames (geneIDs).}

\item{colNames}{The list of column names of the data column to extract to a
matrix (Default = c("logFC", "AveExpr", "P.Value", "adj.P.Val"))}

\item{digits}{Number of decimal places for specified columns. Should be same
length as colNames. (Default = c(2, 2, 4, 3)). If one value supplied, it is used
for all columns.}
}
\value{
A matrix containing the extracted columns.
}
\description{
Take a named list of topTable dataframes and cbinds the requested columns
from each file.  To avoid column name conflicts the names are used as suffixes
to the colnames. Although written for topTable data, this should work on any
named list of dataframes where each member of the list has the same columns.
}
\examples{
dgeObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))
contrastList <- DGEobj::getType(dgeObj, type = "topTable")

mergedData <- topTable.merge(contrastList)
colnames(mergedData)

}
