% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsResiduals.R
\name{testOverdispersion}
\alias{testOverdispersion}
\title{Test for over/underdispersion}
\usage{
testOverdispersion(simulationOutput, alternative = "overdispersion",
  plot = F)
}
\arguments{
\item{simulationOutput}{an object with simulated residuals created by \code{\link{simulateResiduals}}}

\item{alternative}{whether to test for "overdispersion", "underdispersion", or "both"}

\item{plot}{whether to plot output}
}
\description{
This function performs a simulation-based test for over/underdispersion
}
\details{
This test compares the approximate deviance (via squared pearson residuals) with the same quantity from a number of simulated models. It is MUCH slower than the parametric alternative \code{\link{testOverdispersionParametric}}, but potentially more exact in situations where one would expect problems with the chi2 test employed in the parametric test
}
\seealso{
\code{\link{testSimulatedResiduals}}, \code{\link{testSimulatedResiduals}}, \code{\link{testZeroInflation}}, \code{\link{testTemporalAutocorrelation}}, \code{\link{testSpatialAutocorrelation}}, \code{\link{testOverdispersionParametric}}
}

