% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_table.R
\name{stats_table}
\alias{stats_table}
\title{Create Summary Table}
\usage{
stats_table(
  data,
  vars = NULL,
  var_labels = NULL,
  by = NULL,
  statistic_type = "mean_sd",
  pvalue = FALSE,
  test_method = NULL,
  include_na = TRUE
)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{vars}{A character vector of variable names to include in the summary. If NULL (default), all variables are included.}

\item{var_labels}{A list of labels to replace variable names in the table.}

\item{by}{A character string specifying a grouping variable. If NULL (default), no grouping is applied.}

\item{statistic_type}{A character string specifying the type of statistic to report \strong{for continuous variables}. Options are:
\itemize{
\item "mean_sd": Mean (SD) for continuous variables.
\item "median_iqr": Median (Q1; Q3) for continuous variables.
\item "both": Both Mean (SD) and Median (Q1; Q3).
}}

\item{pvalue}{A logical value indicating whether to include p-values in the summary. Defaults to FALSE.}

\item{test_method}{Optional. Only used if \code{pvalue = TRUE}. A list specifying custom statistical tests for each variable. If NULL, \code{gtsummary} will choose default tests based on variable type.}

\item{include_na}{A logical value indicating whether to include rows with missing values in the output. Defaults to TRUE.}
}
\value{
A gtsummary table object.
}
\description{
This function generates a summary table using the \code{gtsummary} package.
It allows customization of the reported statistics for continuous variables and categorical variables.
Users can optionally include p-values for group comparisons and manage
the reporting of missing values.
}
\examples{
# Mean ± SD summary
stats_table(
  vital_signs,
  vars = c("temperature", "saturation"),
  by = "supporto2",
  statistic_type = "mean_sd"
)

# Both mean ± SD and median [Q1; Q3]
stats_table(
 vital_signs,
 statistic_type = "both",
 include_na = FALSE
)

# Add p-value with default tests
stats_table(
 vital_signs,
 vars = c("temperature", "saturation"),
 by = "supporto2",
 pvalue = TRUE
)

# Add p-value and define method
stats_table(
 vital_signs,
 vars = c("temperature", "saturation"),
 by = "supporto2",
 pvalue = TRUE,
 test_method = list(temperature ~ "t.test")
)

}
