% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChooseSelect.r
\name{ChooseSelect}
\alias{ChooseSelect}
\title{Manually choose the historical selectivity pattern}
\usage{
ChooseSelect(Fleet, Stock = NULL, FstYr = NULL, LastYr = NULL,
  SelYears = NULL)
}
\arguments{
\item{Fleet}{A fleet object.}

\item{Stock}{Optional Stock object. If provided, average length-at-maturity
is included on plot for reference.}

\item{FstYr}{Optional value for first historical year. If empty, user must
specify the year in console.}

\item{LastYr}{Optional value for last historical year. If empty, it is assumed to be the current year}

\item{SelYears}{Optional vector of values for each year where selectivity
pattern changed. If empty, user must specify the years in console (comma
separated).}
}
\description{
Input the first historical year, and all years where selectivity pattern
changed (separated by comma).  Interactive plot which allows users to
specify a range for the length at 5\% and full selection (LFS), as well as
selectivity at maximum length for each year.  Produces a simple plot which
shows the range in selectivity pattern for each break-point year.
Selectivity-at-length is fixed in between break-point years.  Note that this
function replaces 'nyears' in the Fleet object with the value defined here
(FstYr:current year).
}
\author{
A. Hordyk
}
