% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{getFref3}
\alias{getFref3}
\title{Calculate Reference Yield}
\usage{
getFref3(x, Asize, nareas, maxage, N, pyears, M_ageArray, Mat_age, Wt_age, V,
  retA, Perr, mov, SRrel, Find, Spat_targ, hs, R0a, SSBpR, aR, bR, MPA, maxF,
  useCPP = TRUE, SSB0)
}
\arguments{
\item{x}{Integer, the simulation number}

\item{Asize}{A matrix (dimensions nsim by nareas) with relative size of areas}

\item{nareas}{The number of spatial areas}

\item{maxage}{The maximum age}

\item{N}{Array of the numbers-at-age in population. Dimensions are nsim, maxage, nyears, nareas.
Only values from the first year (i.e \code{N[,,1,]}) are used, which is the current N-at-age.}

\item{pyears}{The number of years to project forward. Equal to 'nyears' for optimizing for q.}

\item{M_ageArray}{An array (dimensions nsim, maxage, nyears+proyears) with the natural mortality-at-age and year}

\item{Mat_age}{An array (dimensions nsim, maxage, nyears+proyears) with the proportion mature for each age-class}

\item{Wt_age}{An array (dimensions nsim, maxage, nyears+proyears) with the weight-at-age and year}

\item{V}{An array (dimensions nsim, maxage, nyears+proyears) with the vulnerability-at-age and year}

\item{retA}{An array (dimensions nsim, maxage, nyears+proyears) with the probability retained-at-age and year}

\item{Perr}{A matrix (dimensions nsim, nyears+proyears) with the recruitment deviations}

\item{mov}{An array (dimensions nsim, nareas, nareas) with the movement matrix}

\item{SRrel}{A numeric vector nsim long specifying the recruitment curve to use}

\item{Find}{A matrix (dimensions nsim, nyears) with the historical fishing effort}

\item{Spat_targ}{A numeric vector nsim long with the spatial targeting}

\item{hs}{A numeric vector nsim long with the steepness values for each simulation}

\item{R0a}{A matrix (dimensions nsim, nareas) with the unfished recruitment by area}

\item{SSBpR}{A matrix (dimensions nsim, nareas) with the unfished spawning-per-recruit by area}

\item{aR}{A numeric vector nareas long with the Ricker SRR a values}

\item{bR}{A numeric vector nareas long with the Ricker SRR b values}

\item{MPA}{A matrix of spatial closures by year}

\item{maxF}{A numeric value specifying the maximum fishing mortality for any single age class}

\item{useCPP}{logical - use the CPP code? For testing purposes only}

\item{SSB0}{SSB0}
}
\description{
Calculate Reference Yield
}
\author{
A. Hordyk

A. Hordyk
}
