% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmclist}
\alias{plot.dmclist}
\title{plot.dmclist}
\usage{
\method{plot}{dmclist}(
  x,
  ylim = c(-50, 150),
  xlim = NULL,
  col = c("black", "lightgrey"),
  lineType = "l",
  legendPos = "topleft",
  ncol = 1,
  ...
)
}
\arguments{
\item{x}{Output from dmcSims}

\item{ylim}{ylimit for delta plot}

\item{xlim}{xlimit for delta plot}

\item{col}{# color range start/end color}

\item{lineType}{line type ("l", "b", "o") for delta plot}

\item{legendPos}{legend position}

\item{ncol}{number of legend columns}

\item{...}{pars for legend}
}
\description{
Plot the simulation results from the output of dmcSim. The plot
can be an overall summary, or individual plots (activation, trials, pdf, cdf,
caf, delta, all). Plot type summary1 contains an activation plot, example
individual trials, the probability distribution function (PDF), the cumulative
distribution function (CDF), the conditional accuracy function (CAF) and
delta plot. This requires that dmcSim is run with fullData = TRUE. Plot type
summary2 contains only the PDF, CDF, CAF and delta plots and does not require
that dmcSim is run with fullData = TRUE.
}
\examples{
\donttest{
# Example 1
params <- list(amp = seq(20, 30, 2))
dmc <- dmcSims(params)
plot(dmc, ncol = 2, xlim = c(0, 1300), ylim = c(-100, 200))

# Example 2
params <- list(amp=c(10, 20), tau = seq(20, 80, 40), mu = seq(0.2, 0.6, 0.2), nTrl = 50000)
dmc <- dmcSims(params)
plot(dmc, ncol = 2, col=c("green", "blue"), lineType = "l")

}

}
