\name{mvScatter}
\alias{mvScatter}

\title{
	Visualize the distributions of M-value pairs from differentially
	methylated loci (DMLs) or non-DMLs
}
\description{
	Given the M-values, True DMLs and optional the experiment design, 
	plot the scatter plot of M-values. DMLs are marked by red daggers and non-DMLs
	by green circles.
}
\usage{
mvScatter(mv, isDML, pd = NULL, nPlot = 5000)
}

\arguments{
  \item{mv}{The input M-values matrix, NA is not allowed.
}

  \item{isDML}{A binary vector corresponding to each row of 'mv'. 0 indicates non-DML
  and 1 for DML. 
}

  \item{pd}{A design matrix, which can be generated by 'stats::model.matrix'.
  If the M-values are totally paired or single paired, just leave it to be NULL.
}

  \item{nPlot}{The maximum number of loci to be plotted. Using too large value
  will lead to messy scatter and long execution time. Default is 5000.
}
}

\value{
	This function only generates a figure and has no return value.
}

\author{
	Linghao SHEN <sl013@ie.cuhk.edu.hk>
}

\examples{

	# mvScatter
	data(BLCA)
	mvScatter(BLCA$mv, BLCA$truth, nPlot = 10000)
}

