% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DOYPAColors_functions.R
\name{doypa}
\alias{doypa}
\title{Get a DOYPAColors color palette}
\usage{
doypa(palette = NULL, n = NULL, reverse = FALSE, ramp = FALSE)
}
\arguments{
\item{palette}{Character string specifying the desired palette name.
Available palettes: list_doypa_pals().}

\item{n}{Number of colors needed.}

\item{reverse}{Logical. If 'TRUE', reverses the order of colors in the palette.}

\item{ramp}{Logical. If 'TRUE', returns a color ramp (interpolation) instead of a vector of colors.}
}
\value{
A vector of 'n' colors.
}
\description{
This function generates a color vector of n colors for a specified palette.
}
\examples{
# Generate a random color palette
color_palette <- doypa()
preview_doypa_pals(colors = color_palette)

# Generate a color palette of 5 colors using the "buzz" palette
color_palette <- doypa(palette = "buzz", n = 5)
preview_doypa_pals(colors = color_palette, palette = "buzz")

}
\seealso{
'list_doypa_pals' to list available palettes.
'preview_doypa_pals' to preview color palettes.
}
