% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelativeProbabilityNetwork.R
\name{RelativeProbabilityNetwork}
\alias{RelativeProbabilityNetwork}
\title{Computes the relative probability of observing a type of event along a linear network}
\usage{
RelativeProbabilityNetwork(X, lixel_length, sigma, mark, category_mark)
}
\arguments{
\item{X}{- A \code{lpp} object representing a marked point pattern lying on a linear network (\code{linnet} object)}

\item{lixel_length}{- A numeric value representing a lixel length that will be used for creating a split version of the network contained in \code{X}. Then, the length of all the segments of the split network is below \code{lixel_length}}

\item{sigma}{- A numeric value representing the bandwidth parameter (in meters)}

\item{mark}{- Mark of \code{X} that is used to characterize the type of event. The algorithm searches microzones of the network where this mark is over- or underrepresented}

\item{category_mark}{- A numeric/character value from the set allowed in the chosen \code{mark} to compute the relative probability in relation to it}
}
\value{
Returns a list that contains the relative probability values estimated along the network for the type of event specified by \code{mark} and \code{category_mark}
}
\description{
Given a marked point pattern lying on a linear network structure, this function uses kernel density estimation (KDE) to estimate a relative probability of occurrence for a type of event specified by the user through the marks of the pattern. The marks of a point pattern represent additional information of the events that are part of the pattern
}
\examples{
library(DRHotNet)
library(spatstat)
library(spdep)
library(raster)
library(maptools)
\donttest{
rel_probs_rear_end <- RelativeProbabilityNetwork(X = SampleMarkedPattern, 
lixel_length = 50, sigma = 100, mark = "Collision", category_mark = "Rear-end")
}
}
\references{
Baddeley, A., Rubak, E., & Turner, R. (2015). Spatial point patterns: methodology and applications with R. Chapman and Hall/CRC.

Briz-Redon, A., Martinez-Ruiz, F., & Montes, F. (2019). Identification of differential risk hotspots for collision and vehicle type in a directed linear network. Accident Analysis & Prevention, 132, 105278.

Diggle, P. J. (2013). Statistical analysis of spatial and spatio-temporal point patterns. Chapman and Hall/CRC.

Kelsall, J. E., & Diggle, P. J. (1995). Kernel estimation of relative risk. Bernoulli, 1(1-2), 3-16.

McSwiggan, G., Baddeley, A., & Nair, G. (2017). Kernel density estimation on a linear network. Scandinavian Journal of Statistics, 44(2), 324-345.
}
