% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubpathscore.R
\name{getSubpathscore}
\alias{getSubpathscore}
\title{Calculating weighted enrichmentscore of subpathways}
\usage{
getSubpathscore(DE2SubPathresult,inexpData,Label)
}
\arguments{
\item{DE2SubPathresult}{A dataframe with seven columns those are subpath ID, subpath name, subpath size, genes in subpath, centralscore (eigenvector centrality), Pvalue and FDR (The result of function "DE2SubPath").}

\item{inexpData}{A gene expression profile of interest (rows are genes, columns are samples).The data in the expression profile is best not be log2 converted.}

\item{Label}{A character vector consist of "0" and "1" which represent sample class in gene expression profile. "0" means normal sample and "1" means disease sample.}
}
\value{
A dataframe with three columns which are "SubPathID","Weighted-ES","Pvalue".
}
\description{
Function "getSubpathscore" used to calculate enrichmentscore weighted by centrality score of subpathways.
}
\examples{
#Load depend package
library(clusterProfiler)
#Get input data (The "DE2SubPathresult" is the result of function "DE2SubPath")
DE2SubPathresult<-GetExample('DE2SubPathresult')
GEP<-GetExample('GEP')
label<-GetExample('label')
#Run the function
\donttest{SubPathscore<-getSubpathscore(DE2SubPathresult=DE2SubPathresult,inexpData=GEP,Label=label)}
}
