% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.connections.R
\name{datashield.connections}
\alias{datashield.connections}
\title{List the DSConnection objects in the analytic environment}
\usage{
datashield.connections(env = getOption("datashield.env", globalenv()))
}
\arguments{
\item{env}{The environment where to search for the connection symbols. Try to get it from the
'datashield.env' option, with default to the Global Environment.}
}
\value{
Returns a list of \code{\link{DSConnection-class}} objects and advises
the user how best to respond depending whether there are zero, one or multiple connections detected.
}
\description{
This function identifies and prints all \code{\link{DSConnection-class}} objects
in the analytic environment. If there are no DSConnection servers in the analytic
environment \link{datashield.connections} reminds the user that they have to login to a valid set of
DataSHIELD aware servers. If there is only one set of DSConnections, it copies that one set and
names the copy 'default.connections'. This default set will then be used by
default by all subsequent calls to client-side functions. If there is more than one set of DSConnections
in the analytic environment, \link{datashield.connections} tells the user that they can either explicitly specify the
DSConnections to be used by each client-side function by providing an explicit "datasources=" argument
for each call, or can alternatively use the \link{datashield.connections_default} function to specify a default
set of DSConnections to be used by all client-side calls unless over-ruled by the 'datasources=' argument.
}
\seealso{
Other Connections management: 
\code{\link{datashield.connections_default}()},
\code{\link{datashield.connections_find}()}
}
\concept{Connections management}
