% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsListPackages}
\alias{dsListPackages}
\title{Get the DataSHIELD packages}
\usage{
dsListPackages(conn)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}
}
\value{
A data.frame with columns: name, version.
}
\description{
Get the list of DataSHIELD packages with their version, that have been configured on the remote data repository.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsListPackages")}
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsListPackages(con)
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListProfiles}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRestoreWorkspace}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
