% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_cul.R
\name{write_cul}
\alias{write_cul}
\title{Reads parameters from a single DSSAT cultivar parameter file (*.CUL)}
\usage{
write_cul(cul, file_name)
}
\arguments{
\item{cul}{a DSSAT_tbl containing the contents of a DSSAT cultivar parameter file}

\item{file_name}{a character vector of length one that contains the name
of a single DSSAT output file}
}
\value{
a tibble containing the data from the raw DSSAT output
}
\description{
Reads parameters from a single DSSAT cultivar parameter file (*.CUL)
}
\examples{

# Extract file path for sample cultivar file path
sample_cul_file <- system.file('extdata','SAMPLE.CUL',package='DSSAT')

# Read sample cultivar file
cul <- read_cul(sample_cul_file)

# Create example cultivar file path
sample_cul_file2 <- paste0(tempdir(),'/SAMPLE.CUL')

# Write out sample cultivar file
write_cul(cul,sample_cul_file2)

}
