% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice_in_col_name.R
\name{splice_in_col_name}
\alias{splice_in_col_name}
\title{Splice column name into vector of column names}
\usage{
splice_in_col_name(col_names, new_name)
}
\arguments{
\item{col_names}{A length-one character vector of a header line
from a DSSAT format output file}

\item{new_name}{A length-one character vector that contains a
column name suspected to be a substring of one of the existing
elements of the \code{col_names} vector.}
}
\value{
If \code{new_name} matches a substring, the function will
return a new character vector with it spliced into the existing
\code{col_names} in the position immediately before the element
that contained the matching substring. Otherwise the original
\code{col_names} will be returned.
}
\description{
Splice column name into vector of column names
}
\examples{

cnames <-
  c("@VAR#","VAR-NAME........","EXPNO","ECO#","TB(1)TO1(1)TO2(1)","TM(1)")

splice_in_col_name(cnames,"TB(1)")
}
\keyword{internal}
