% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovMatch.R
\name{CovMatch}
\alias{CovMatch}
\title{Covariate Matching}
\usage{
CovMatch(data, xCol, xCol.circ, thrs, priority)
}
\arguments{
\item{data}{a list, consisting of data sets to match, also each of the individual data set can be dataframe or a matrix}

\item{xCol}{a vector stating the column position of covariates used}

\item{xCol.circ}{a vector stating the column position of circular variables}

\item{thrs}{a numerical or a vector of threshold values for each covariates, against which matching happens
It should be a single value or a vector of values representing threshold for each of the covariate}

\item{priority}{a boolean, default value False, otherwise computes the sequence of matching}
}
\value{
a list containing :
  \itemize{
  \item originalData - The data sets provided for matching
  \item matchedData - The data sets after matching
  \item MinMaxOriginal - The minimum and maximum value in original data for each covariate used in matching
  \item MinMaxMatched - The minimum and maximum value in matched data for each covariates used in matching
}
}
\description{
The function aims to take list of two data sets and returns the after
matched data sets using user specified covariates and threshold
}
\examples{

data1 = data1[1:100, ]
data2 = data2[1:100, ]
data = list(data1, data2)
xCol = 2
xCol.circ = NULL
thrs = 0.1
priority = FALSE
matched_data = CovMatch(data, xCol, xCol.circ, thrs, priority)

}
\references{
Ding, Y. (2019). Data Science for Wind Energy. Chapman & Hall, Boca Raton, FL.
}
