% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.functions.R, R/Simulation.R,
%   R/Single.Obs.LT.Survey.R, R/Single.Obs.PT.Survey.R
\docType{methods}
\name{create.survey.results}
\alias{create.survey.results}
\alias{create.survey.results,Simulation-method}
\alias{create.survey.results,Single.Obs.LT.Survey-method}
\alias{create.survey.results,Single.Obs.PT.Survey-method}
\title{S4 generic method to simulate a survey}
\usage{
create.survey.results(object, dht.tables = FALSE, ...)

\S4method{create.survey.results}{Simulation}(object, dht.tables = FALSE, ...)

\S4method{create.survey.results}{Single.Obs.LT.Survey}(object,
  dht.tables = FALSE, ...)

\S4method{create.survey.results}{Single.Obs.PT.Survey}(object,
  dht.tables = FALSE, ...)
}
\arguments{
\item{object}{an object of class Simulation}

\item{dht.tables}{logical value indicating whether or the data 
tables for Hortvitz-Thompson estimation are required.}

\item{...}{allows a region object to be passed in}
}
\value{
an object of class LT.Survey.Results
}
\description{
Simulates the process by which individuals / clusters are detected. 
Currently this is only implemented for line transect surveys. It returns an 
object of class LT.Survey.Results which contains a population, a set of 
transects, distance data and if requested region, sample and obs tables.
}
\details{
This object can be displayed using \code{plot()} or the distance data
extracted using \code{get.distance.data()}. You can then investigate 
fitting models to this data.
}
\examples{
\dontrun{
survey.results <- create.survey.results(simulation, dht.table = TRUE)

plot(survey.results)
}

}
