% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{cols.DTSg}
\alias{cols.DTSg}
\alias{cols}
\title{Get Column Names}
\usage{
\method{cols}{DTSg}(x, class = "all", ...)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{class}{A character string matched to the first element of each column's
\code{\link{class}} vector or \code{"all"} for all column names.}

\item{\dots}{Not used (S3 method only).}
}
\value{
Returns a character vector.
}
\description{
Queries all column names of a \code{\link{DTSg}} object or those of a certain
 \code{\link{class}} only.
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# get names of numeric columns
## R6 method
x$cols(class = "numeric")

## S3 method
cols(x = x, class = "numeric")

}
\seealso{
\code{\link{DTSg}}, \code{\link{class}}
}
