% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Swrappers.R
\name{aggregate.DTSg}
\alias{aggregate.DTSg}
\alias{aggregate}
\title{Aggregate Values}
\usage{
\method{aggregate}{DTSg}(
  x,
  funby,
  fun,
  ...,
  cols = self$cols(class = "numeric"),
  n = FALSE,
  ignoreDST = FALSE,
  clone = getOption("DTSgClone")
)
}
\arguments{
\item{x}{A \code{\link{DTSg}} object (S3 method only).}

\item{funby}{One of the temporal aggregation level functions described in
\code{\link{TALFs}} or a user defined temporal aggregation level function.
See details for further information.}

\item{fun}{A summary function applied columnwise to all the values of the
same temporal aggregation level, for instance, \code{\link{mean}}. Its
return value must be of length one.}

\item{\dots}{Further arguments passed on to \code{fun}.}

\item{cols}{A character vector specifying the columns to aggregate.}

\item{n}{A logical specifying if a column named \emph{.n} giving the number
of values per temporal aggregation level is added. See details for further
information.}

\item{ignoreDST}{A logical specifying if day saving time is ignored during
aggregation. See details for further information.}

\item{clone}{A logical specifying if the object is modified in place or if a
clone (copy) is made beforehand.}
}
\value{
Returns an aggregated \code{\link{DTSg}} object.
}
\description{
Applies a temporal aggregation level function to the \emph{.dateTime} column
 of a \code{\link{DTSg}} object and aggregates its \emph{values} columnwise
 to the function's temporal aggregation level utilising a provided summary
 function. Additionally, it sets the object's \emph{aggregated} field to
 \code{TRUE}. See \code{\link{DTSg}} for further information.
}
\details{
User defined temporal aggregation level functions have to return a
 \code{\link{POSIXct}} vector of the same length as the time series and
 accept two arguments: a \code{\link{POSIXct}} vector as its first and a
 \code{\link{list}} with helper data as its second. This \code{\link{list}}
 in turn contains the following named elements:
 \itemize{
   \item \emph{timezone:} Same as \emph{timezone} field. See
     \code{\link{DTSg}} for further information.
   \item \emph{ignoreDST:} Same as \code{ignoreDST} argument.
   \item \emph{periodicity:} Same as \emph{periodicity} field. See
     \code{\link{DTSg}} for further information.
 }

Depending on the number of columns to aggregate, the \emph{.n} column
 contains different counts:
 \itemize{
   \item One column: The counts are calculated from the value column without
     any missing values. This means that missing values are always stripped
     regardless of the value of a possible \code{na.rm} argument.
   \item More than one column: The counts are calculated from the
     \emph{.dateTime} column including all missing values.
 }

\code{ignoreDST} tells a temporal aggregation level function if it is
 supposed to ignore day saving time while forming new timestamps. This can be
 a desired feature for time series strictly following the position of the sun
 (such as hydrological time series). Doing so ensures that diurnal variations
 are preserved under all circumstances and that all intervals are of
 \dQuote{correct} length. This feature requires that the periodicity of the
 time series is not unrecognised and is supported by the following temporal
 aggregation level functions of the package:
 \itemize{
   \item \code{\link{byY_____}}
   \item \code{\link{byYQ____}}
   \item \code{\link{byYm____}}
   \item \code{\link{byYmd___}}
   \item \code{\link{by_Q____}}
   \item \code{\link{by_m____}}
   \item \code{\link{by___H__}}
 }
}
\examples{
# new DTSg object
x <- DTSg$new(values = flow)

# mean yearly river flows
## R6 method
x$aggregate(funby = byY_____, fun = mean, na.rm = TRUE)

## S3 method
aggregate(x = x, funby = byY_____, fun = mean, na.rm = TRUE)

}
\seealso{
\code{\link{DTSg}}, \code{\link{TALFs}}, \code{\link{cols}},
 \code{\link{POSIXct}}, \code{\link{list}}
}
