% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_6FB.R
\name{compute.fb}
\alias{compute.fb}
\title{Fractional Bias (FB)}
\usage{
compute.fb(Y, X, verbose = F)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}

\item{verbose}{if TRUE, print advice about the quality of the model}
}
\description{
Estimates the Fractional Bias (FB) of two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the value of FB of two vectors corresponding to univariate signals, indicating whether predicted values are underestimated or overestimated compared to true values.
A perfect imputation model gets \eqn{FB = 0}.
An acceptable imputation model gives \eqn{FB <= 0.3}.
Both vectors Y and X must be of equal length, on the contrary an error will be displayed.
In both input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataDTWBI)
X <- dataDTWBI[, 1] ; Y <- dataDTWBI[, 2]
compute.fb(Y,X)
compute.fb(Y,X, verbose = TRUE)

# If mean(X)=mean(Y)=0, it is impossible to estimate FB,
# unless both true and imputed values vectors are constant.
# By definition, in this case, FB = 0.
X <- rep(0, 10) ; Y <- rep(0, 10)
compute.fb(Y,X)

# If true and imputed values are not zero and are opposed, FB = Inf.
X <- rep(runif(1), 10)
Y <- -X
compute.fb(Y,X)
}
\author{
DEZECACHE Camille, PHAN Thi Thu Hong, POISSON-CAILLAULT Emilie
}
