% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FillIn.R
\name{TimeExpand}
\alias{TimeExpand}
\title{Expands a data set so that it includes an observation for each time point in
a sequence. Works with grouped data.}
\usage{
TimeExpand(data, GroupVar, TimeVar, begin, end, by = 1)
}
\arguments{
\item{data}{a data frame.}

\item{GroupVar}{the variable in \code{data} that signifies the group
variable.}

\item{TimeVar}{the variable in \code{data} that signifies the time variable.
The sequence will be expanded between its minimum and maximum value if
\code{begin} and \code{end} are not specified.}

\item{begin}{numeric of length 1. Specifies beginning time point.
Only relevant if \code{end} is specified.}

\item{end}{numeric of length 1. Specifies ending time point.
Only relevant if \code{begin} is specified.}

\item{by}{numeric or character string specifying the steps in the
\code{TimeVar} sequence. Can use \code{"month"}, \code{"year"} etc for
POSIXt data.}
}
\description{
Expands a data set so that it includes an observation for each time point in
a sequence. Works with grouped data.
}
\examples{
Data <- data.frame(country = c("Cambodia", "Camnodia", "Japan", "Japan"),
                   year = c(1990, 2001, 1994, 2012))

ExpandedData <- TimeExpand(Data, GroupVar = 'country', TimeVar = 'year')
}

