% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustDate.R
\name{adjustDate}
\alias{adjustDate}
\title{Fix the time zone}
\usage{
adjustDate(data = NULL, col_date = NULL, col_hour = NULL, fuso = NULL)
}
\arguments{
\item{data}{Data frame containing the data}

\item{col_date}{Column containing the dates}

\item{col_hour}{Column containing the time. It must be in the format "hh", "hh:mm", or "hh:mm:ss"; only the hours "hh" will be used for conversion.}

\item{fuso}{Time zone for correction. Query OlsonNames()}
}
\value{
Data frame with the corrected timezone
}
\description{
Allows you to correct the timezone based on a date column and another time column
}
\examples{
address <-
 base::system.file("extdata",
                    "ex1_inmet.CSV",
                    package = "DataMetProcess")

df <-
  read.table(
    address,
    h=TRUE,
    sep = ";",
    dec = ",",
    skip = 8,
    na.strings = -9999,
    check.names = FALSE
  )

df$Data = as.Date(df$Data,format = "\%d/\%m/\%Y")


df <-
  adjustDate(df,
             colnames(df)[1],
             colnames(df)[2],
             fuso = "America/Bahia")

head(df[1:2])

}
