% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simp.emd.R
\name{simp.emd}
\alias{simp.emd}
\title{Simplifies the components of an EMD}
\usage{
simp.emd(emd = NULL, m = NULL, dt = NULL, repl = 1, use.names = FALSE)
}
\arguments{
\item{emd}{emd-type object}

\item{m}{a matrix of the amplitude values (xy) of the components, each
column being a component. Each column should have the same number of non NA
values. Vectors, for 1 component, are accepted. Is overridden by emd.}

\item{dt}{the depth or time value. Is overridden by emd.}

\item{repl}{the amount of replicates in m. Is overridden by emd.}

\item{use.names}{whether to use the column names to identify problematic
extrema}
}
\value{
a list of the depth or time values ($dt) of the simplified IMF
(Intrinsic Mode Function), of their amplitude ($xy), and of the position
and component of problematic multiple extrema ($multiple_extrema) and
crossing extrema ($crossing_extrema)
}
\description{
Simplifies the component of an EMD to only extremas and
zero-crossings, and outputs problematic extrema: multiple extrema (extrema
not separated by zero-crossings) and crossing extrema (extrema at zero).
}
\examples{
xytest <- c(0.5, 1,-1,-0.85,-0.5,-1,-0.5,-1,1,0.5,0,0,
            1,-1,0,1,2,-2,1,2,1,3,0,-1,-1,3,0)

repeatafterme <- 2

m  <- matrix(rep(xytest,repeatafterme), ncol = repeatafterme)
dt <- 1:length(xytest)

res <- simp.emd(m = m, dt = dt, repl = repeatafterme)

opar <- par("mfrow")

par(mfrow = c(1,1))

plot(dt, xytest, type = "o", pch = 19)
abline(h = 0, col = "grey")

me <- res$multiple_extrema$dt[res$multiple_extrema$repl == 1]
ce <- res$crossing_extrema$dt[res$multiple_extrema$repl == 1]

abline(v = me, col = "orange")
abline(v = ce, col = "darkred")

points(res$dt[,1], res$xy[,1], col = "red", pch = 19)

par(mfrow = opar)

}
