/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamWidget;

public class ParamColorWidget
extends ParamWidget
implements ActionListener {
    private JButton colourButton;
    private Color colourValue;

    public ParamColorWidget() {
    }

    public ParamColorWidget(Param param) {
        this.setModel(param);
    }

    public void setModel(Param param) {
        this.model = param;
        this.initAsColour();
        if (this.model.getValue() != null) {
            this.colourButton.setForeground((Color)this.model.getValue());
            this.colourValue = (Color)this.model.getValue();
        }
    }

    public void updateModel() {
        if (this.colourValue != null) {
            this.model.setValue(this.colourValue);
        }
    }

    public Param getModel() {
        this.updateModel();
        return this.model;
    }

    private void initAsColour() {
        this.removeAll();
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.setPreferredSize(new Dimension(241, 37));
        int n = 58;
        this.label = new JLabel();
        this.add((Component)this.label, new AnchorConstraint(202, 234, 689, 12, 1, 0, 0, 2));
        if (this.model != null) {
            this.label.setText(this.model.getTitle());
            n = SwingUtilities.computeStringWidth(this.label.getFontMetrics(this.label.getFont()), this.model.getTitle());
        }
        int n2 = Math.max(n + 22, 80);
        this.colourButton = new JButton("Set Colour");
        this.add((Component)this.colourButton, new AnchorConstraint(148, 12, 743, n2, 1, 2, 0, 2));
        this.colourButton.setPreferredSize(new Dimension(122, 22));
        this.colourButton.removeActionListener(this);
        this.colourButton.addActionListener(this);
        this.setPreferredSize(new Dimension(200, 30));
        this.setMaximumSize(new Dimension(2000, 30));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Choose Colour", this.colourButton.getForeground());
        if (color != null) {
            this.colourButton.setForeground(color);
            this.colourValue = color;
        }
    }
}

