/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.util.LinkedHashMap;
import java.util.Map;
import org.rosuda.deducer.plots.PlottingElement;
import org.rosuda.deducer.plots.PlottingElementMenuDialog;
import org.rosuda.deducer.plots.Position;

public class PlotController {
    public static boolean initialized = false;
    protected static String[] names = new String[]{"Templates", "Geometric Elements", "Statistics", "Scales", "Facets", "Coordinates", "Other"};
    protected static Map templates;
    protected static Map geoms;
    protected static Map stats;
    protected static Map scales;
    protected static Map facets;
    protected static Map themes;
    protected static Map coords;
    protected static Map pos;
    protected static Map menuElements;
    protected static String[] templateNames;
    protected static String[] geomNames;
    protected static String[] statNames;
    protected static String[] scaleNames;
    protected static String[] facetNames;
    protected static String[] coordNames;
    protected static String[] posNames;
    protected static String[] themeNames;

    public static void init() {
        if (!initialized) {
            int n;
            templates = new LinkedHashMap();
            menuElements = new LinkedHashMap();
            geoms = new LinkedHashMap();
            for (n = 0; n < geomNames.length; ++n) {
                geoms.put(geomNames[n], PlottingElement.createElement("geom", geomNames[n]));
            }
            stats = new LinkedHashMap();
            for (n = 0; n < statNames.length; ++n) {
                stats.put(statNames[n], PlottingElement.createElement("stat", statNames[n]));
            }
            scales = new LinkedHashMap();
            for (n = 0; n < scaleNames.length; ++n) {
                scales.put(scaleNames[n], PlottingElement.createElement("scale", scaleNames[n]));
            }
            facets = new LinkedHashMap();
            for (n = 0; n < facetNames.length; ++n) {
                facets.put(facetNames[n], PlottingElement.createElement("facet", facetNames[n]));
            }
            coords = new LinkedHashMap();
            for (n = 0; n < coordNames.length; ++n) {
                coords.put(coordNames[n], PlottingElement.createElement("coord", coordNames[n]));
            }
            themes = new LinkedHashMap();
            for (n = 0; n < themeNames.length; ++n) {
                themes.put(themeNames[n], PlottingElement.createElement("theme", themeNames[n]));
            }
            for (n = 0; n < templateNames.length; ++n) {
                templates.put(templateNames[n], PlottingElement.createElement("template", templateNames[n]));
            }
            pos = new LinkedHashMap();
            pos.put("identity", new Position("identity", null, null));
            pos.put("stack", new Position("stack", null, null));
            pos.put("dodge", new Position("dodge", null, null));
            pos.put("jitter", new Position("jitter", null, null));
            initialized = true;
        }
    }

    public static String[] getNames() {
        return names;
    }

    public static Map getGeoms() {
        return geoms;
    }

    public static String[] getGeomNames() {
        return geomNames;
    }

    public static Map getStats() {
        return stats;
    }

    public static String[] getStatNames() {
        return statNames;
    }

    public static Map getScales() {
        return scales;
    }

    public static String[] getScaleNames() {
        return scaleNames;
    }

    public static Map getFacets() {
        return facets;
    }

    public static String[] getFacetNames() {
        return facetNames;
    }

    public static Map getCoords() {
        return coords;
    }

    public static String[] getCoordNames() {
        return coordNames;
    }

    public static Map getPositions() {
        return pos;
    }

    public static String[] getPositionNames() {
        return posNames;
    }

    public static Map getThemes() {
        return themes;
    }

    public static String[] getThemeNames() {
        return themeNames;
    }

    public static Map getTemplates() {
        return templates;
    }

    public static String[] getTemplateNames() {
        return templateNames;
    }

    public static void addTemplate(PlottingElement plottingElement) {
        String[] stringArray = templateNames;
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = plottingElement.getName();
        templates.put(plottingElement.getName(), plottingElement);
    }

    public static void addGeom(PlottingElement plottingElement) {
        String[] stringArray = geomNames;
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = plottingElement.getName();
        geoms.put(plottingElement.getName(), plottingElement);
    }

    public static void addStat(PlottingElement plottingElement) {
        String[] stringArray = statNames;
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = plottingElement.getName();
        stats.put(plottingElement.getName(), plottingElement);
    }

    public static void addScale(PlottingElement plottingElement) {
        String[] stringArray = scaleNames;
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = plottingElement.getName();
        scales.put(plottingElement.getName(), plottingElement);
    }

    public static void addFacet(PlottingElement plottingElement) {
        String[] stringArray = facetNames;
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = plottingElement.getName();
        facets.put(plottingElement.getName(), plottingElement);
    }

    public static void addCoord(PlottingElement plottingElement) {
        String[] stringArray = coordNames;
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = plottingElement.getName();
        coords.put(plottingElement.getName(), plottingElement);
    }

    public static void addPosition(Position position) {
        String[] stringArray = posNames;
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = position.name;
        pos.put(position.name, position);
    }

    public static void addTheme(PlottingElement plottingElement) {
        String[] stringArray = themeNames;
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = plottingElement.getName();
        themes.put(plottingElement.getName(), plottingElement);
    }

    public static void addMenuElement(String string, PlottingElement plottingElement) {
        menuElements.put(string, plottingElement);
    }

    public static PlottingElementMenuDialog getMenuDialog(String string) {
        PlottingElement plottingElement = (PlottingElement)menuElements.get(string);
        if (plottingElement == null) {
            plottingElement = (PlottingElement)templates.get(string);
            PlotController.addMenuElement(string, plottingElement);
        }
        if (plottingElement == null) {
            return null;
        }
        return new PlottingElementMenuDialog(null, plottingElement);
    }

    static {
        templateNames = new String[]{"bar", "grouped_bar", "histogram", "density", "grouped_density", "simple_dotplot", "grouped_dotplot", "mean", "line", "grouped_line", "simple_boxplot", "grouped_boxplot", "scatter", "scatter_smooth", "histogram_2d", "bubble"};
        geomNames = new String[]{"abline", "area", "bar", "bin2d", "blank", "boxplot", "contour", "crossbar", "density", "density2d", "dotplot", "errorbar", "errorbarh", "freqpoly", "hex", "histogram", "hline", "jitter", "line", "linerange", "path", "point", "pointrange", "polygon", "quantile", "raster", "rect", "ribbon", "rug", "segment", "smooth", "step", "text", "tile", "violin", "vline"};
        statNames = new String[]{"abline", "bin", "bin2d", "bindot", "binhex", "boxplot", "contour", "density", "density2d", "ecdf", "function", "hline", "identity", "qq", "quantile", "smooth", "spoke", "sum", "summary", "unique", "ydensity", "vline"};
        scaleNames = new String[]{"area", "size", "size_manual", "size_identity", "colour_gradient", "colour_hue", "colour_brewer", "colour_gradient2", "colour_gradientn", "colour_grey", "colour_manual", "colour_identity", "fill_gradient", "fill_hue", "fill_brewer", "fill_gradient2", "fill_gradientn", "fill_grey", "fill_manual", "fill_identity", "x_continuous", "x_discrete", "x_date", "x_datetime", "y_continuous", "y_discrete", "y_date", "y_datetime", "z_continuous", "z_discrete", "z_date", "z_datetime", "linetype", "linetype_identity", "linetype_manual", "shape", "shape_identity", "shape_manual", "alpha"};
        facetNames = new String[]{"grid", "wrap"};
        coordNames = new String[]{"cartesian", "equal", "flip", "map", "polar", "trans"};
        posNames = new String[]{"dodge", "identity", "jitter", "stack", "fill"};
        themeNames = new String[]{"grey", "bw", "classic", "minimal", "theme", "title", "xlab", "ylab"};
    }
}

