% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_arm_designer.R
\name{multi_arm_designer}
\alias{multi_arm_designer}
\title{Create a design with multiple experimental arms}
\usage{
multi_arm_designer(N = 30, m_arms = 3, means = rep(0, m_arms),
  sds = rep(1, m_arms), conditions = 1:m_arms, fixed = NULL)
}
\arguments{
\item{N}{An integer. Sample size.}

\item{m_arms}{An integer. Number of arms.}

\item{means}{A numeric vector of length \code{m_arms}.  Average outcome in each arm.}

\item{sds}{A nonnegative numeric vector of length \code{m_arms}. Standard deviations for each of the arms.}

\item{conditions}{A vector of length \code{m_arms}. The names of each arm. It can be numeric or a character without blank spaces.}

\item{fixed}{A character vector. Names of arguments to be fixed in design. By default \code{m_arms} and \code{conditions} are always fixed.}
}
\value{
A function that returns a design.
}
\description{
This designer creates a design \code{m_arms} experimental arms, each assigned with equal probabilities.
}
\examples{

# To make a design using default arguments:
design <- multi_arm_designer()


# A design with different mean and sd in each arm
design <- multi_arm_designer(means = c(0, 0.5, 2), sd =  c(1, 0.1, 0.5))

design <- multi_arm_designer(N = 80, m_arms = 4, means = 1:4,
                             fixed = c("means", "sds"))

}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{experiment}
\concept{multiarm trial}
