% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_discontinuity_designer.R
\name{regression_discontinuity_designer}
\alias{regression_discontinuity_designer}
\title{Create a regression discontinuity design}
\usage{
regression_discontinuity_designer(N = 1000, tau = 0.15, cutoff = 0.5,
  bandwidth = 0.5, poly_order = 4)
}
\arguments{
\item{N}{An integer. Size of population to sample from.}

\item{tau}{A number. Difference in potential outcomes functions at the threshold.}

\item{cutoff}{A number in (0,1). Threshold on running variable beyond which units are treated.}

\item{bandwidth}{A number. Bandwidth around threshold from which to include units.}

\item{poly_order}{An integer. Order of the polynomial regression used to estimate the jump at the cutoff.}
}
\value{
A regression discontinuity design.
}
\description{
Builds a design with sample from population of size \code{N}. The average treatment effect local to the cutpoint is equal to \code{tau}. It allows for specification of the order of the polynomial regression (\code{poly_order}), cutoff value on the running variable (\code{cutoff}), and size of bandwidth around the cutoff (\code{bandwidth}).
}
\examples{
# Generate a regression discontinuity design using default arguments:
regression_discontinuity_design <- regression_discontinuity_designer()
}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{observational}
\concept{regression discontinuity}
