% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_agg_degree_out.R
\name{get_agg_degree_out}
\alias{get_agg_degree_out}
\title{Get an aggregate value from the outdegree of nodes}
\usage{
get_agg_degree_out(graph, agg, conditions = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{agg}{the aggregation function to use for
summarizing outdegree values from graph nodes. The
following aggregation functions can be used:
\code{sum}, \code{min}, \code{max}, \code{mean}, or
\code{median}.}

\item{conditions}{an option to use filtering
conditions for the nodes to consider.}
}
\value{
a vector with an aggregate outdegree value.
}
\description{
Get a single, aggregate value from the
outdegree values for all nodes in a graph, or, a subset
of graph nodes.
}
\examples{
# Create a random graph
random_graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the mean outdegree value from all
# nodes in the graph
get_agg_degree_out(
  graph = random_graph,
  agg = "mean")
#> [1] 3.666667

# Other aggregation functions can be used
# (`min`, `max`, `median`, `sum`); let's
# get the median in this example
get_agg_degree_out(
  graph = random_graph,
  agg = "median")
#> [1] 3

# The aggregation of outdegree can occur
# for a subset of the graph nodes and this
# is made possible by specifying `conditions`
# for the nodes
get_agg_degree_out(
  graph = random_graph,
  agg = "mean",
  conditions = value < 5.0)
#> [1] 3.666667
}
