context("Graph validation")

test_that("Using an invalid graph with trigger an error", {

  # Create an empty graph
  graph <- create_graph()

  # Make the graph invalid
  graph$nodes_df <- NULL
  invalid_graph <- graph

  # Create a valid graph
  valid_graph <- create_graph()

  # Expect errors with all functions that perform
  # graph validation
  expect_error(add_balanced_tree(invalid_graph))
  expect_error(add_cycle(invalid_graph))
  expect_error(add_edge(invalid_graph))
  expect_error(add_edge_clone(invalid_graph))
  expect_error(add_edge_df(invalid_graph))
  expect_error(add_edges_from_table(invalid_graph))
  expect_error(add_edges_w_string(invalid_graph))
  expect_error(add_full_graph(invalid_graph))
  expect_error(add_forward_edges_ws(invalid_graph))
  expect_error(add_global_graph_attrs(invalid_graph))
  expect_error(add_graph_action(invalid_graph))
  expect_error(add_n_node_clones(invalid_graph))
  expect_error(add_n_nodes(invalid_graph))
  expect_error(add_n_nodes_ws(invalid_graph))
  expect_error(add_node(invalid_graph))
  expect_error(add_node_df(invalid_graph))
  expect_error(add_nodes_from_df_cols(invalid_graph))
  expect_error(add_nodes_from_table(invalid_graph))
  expect_error(add_path(invalid_graph))
  expect_error(add_prism(invalid_graph))
  expect_error(add_star(invalid_graph))
  expect_error(add_reverse_edges_ws(invalid_graph))
  expect_error(add_to_series(invalid_graph))
  expect_error(cache_edge_attrs(invalid_graph))
  expect_error(cache_edge_attrs_ws(invalid_graph))
  expect_error(cache_edge_count_ws(invalid_graph))
  expect_error(cache_node_attrs(invalid_graph))
  expect_error(cache_node_attrs_ws(invalid_graph))
  expect_error(cache_node_count_ws(invalid_graph))
  expect_error(clear_global_graph_attrs(invalid_graph))
  expect_error(clear_selection(invalid_graph))
  expect_error(colorize_edge_attrs(invalid_graph))
  expect_error(colorize_node_attrs(invalid_graph))
  expect_error(copy_edge_attrs(invalid_graph))
  expect_error(copy_node_attrs(invalid_graph))
  expect_error(count_asymmetric_node_pairs(invalid_graph))
  expect_error(count_automorphisms(invalid_graph))
  expect_error(count_mutual_node_pairs(invalid_graph))
  expect_error(count_unconnected_node_pairs(invalid_graph))
  expect_error(create_complement_graph(invalid_graph))
  expect_error(create_series(invalid_graph))
  expect_error(create_subgraph_ws(invalid_graph))
  expect_error(delete_edge(invalid_graph))
  expect_error(delete_edges_ws(invalid_graph))
  expect_error(delete_global_graph_attrs(invalid_graph))
  expect_error(delete_graph_actions(invalid_graph))
  expect_error(delete_node(invalid_graph))
  expect_error(delete_nodes_ws(invalid_graph))
  expect_error(display_metagraph(invalid_graph))
  expect_error(do_bfs(invalid_graph))
  expect_error(do_dfs(invalid_graph))
  expect_error(drop_edge_attrs(invalid_graph))
  expect_error(drop_node_attrs(invalid_graph))
  expect_error(edge_count(invalid_graph))
  expect_error(edge_info(invalid_graph))
  expect_error(edge_present(invalid_graph))
  expect_error(edge_rel(invalid_graph))
  expect_error(export_csv(invalid_graph))
  expect_error(export_graph(invalid_graph))
  expect_error(generate_dot(invalid_graph))
  expect_error(get_adhesion(invalid_graph))
  expect_error(get_agg_degree_in(invalid_graph))
  expect_error(get_agg_degree_out(invalid_graph))
  expect_error(get_agg_degree_total(invalid_graph))
  expect_error(get_all_connected_nodes(invalid_graph))
  expect_error(get_alpha_centrality(invalid_graph))
  expect_error(get_articulation_points(invalid_graph))
  expect_error(get_attr_dfs(invalid_graph))
  expect_error(get_authority_centrality(invalid_graph))
  expect_error(get_betweenness(invalid_graph))
  expect_error(get_bridging(invalid_graph))
  expect_error(get_cache(invalid_graph))
  expect_error(get_closeness(invalid_graph))
  expect_error(get_cmty_edge_btwns(invalid_graph))
  expect_error(get_cmty_fast_greedy(invalid_graph))
  expect_error(get_cmty_l_eigenvec(invalid_graph))
  expect_error(get_cmty_louvain(invalid_graph))
  expect_error(get_cmty_walktrap(invalid_graph))
  expect_error(get_closeness_vitality(invalid_graph))
  expect_error(get_common_nbrs(invalid_graph))
  expect_error(get_constraint(invalid_graph))
  expect_error(get_coreness(invalid_graph))
  expect_error(get_degree_distribution(invalid_graph))
  expect_error(get_degree_histogram(invalid_graph))
  expect_error(get_degree_in(invalid_graph))
  expect_error(get_degree_out(invalid_graph))
  expect_error(get_degree_total(invalid_graph))
  expect_error(get_dice_similarity(invalid_graph))
  expect_error(get_eccentricity(invalid_graph))
  expect_error(get_edge_attrs(invalid_graph))
  expect_error(get_edge_attrs_ws(invalid_graph))
  expect_error(get_edge_count_w_multiedge(invalid_graph))
  expect_error(get_edge_df(invalid_graph))
  expect_error(get_eigen_centrality(invalid_graph))
  expect_error(get_girth(invalid_graph))
  expect_error(get_global_graph_attrs(invalid_graph))
  expect_error(get_max_eccentricity(invalid_graph))
  expect_error(get_min_eccentricity(invalid_graph))
  expect_error(get_graph_actions(invalid_graph))
  expect_error(get_graph_log(invalid_graph))
  expect_error(get_graph_name(invalid_graph))
  expect_error(get_graph_time(invalid_graph))
  expect_error(get_jaccard_similarity(invalid_graph))
  expect_error(get_last_edges_created(invalid_graph))
  expect_error(get_last_nodes_created(invalid_graph))
  expect_error(get_leverage_centrality(invalid_graph))
  expect_error(get_max_eccentricity(invalid_graph))
  expect_error(get_mean_distance(invalid_graph))
  expect_error(get_min_cut_between(invalid_graph))
  expect_error(get_min_eccentricity(invalid_graph))
  expect_error(get_min_spanning_tree(invalid_graph))
  expect_error(get_multiedge_count(invalid_graph))
  expect_error(get_nbrs(invalid_graph))
  expect_error(get_node_attrs(invalid_graph))
  expect_error(get_node_attrs_ws(invalid_graph))
  expect_error(get_node_df(invalid_graph))
  expect_error(get_node_ids(invalid_graph))
  expect_error(get_non_nbrs(invalid_graph))
  expect_error(get_pagerank(invalid_graph))
  expect_error(get_paths(invalid_graph))
  expect_error(get_periphery(invalid_graph))
  expect_error(get_predecessors(invalid_graph))
  expect_error(get_radiality(invalid_graph))
  expect_error(get_reciprocity(invalid_graph))
  expect_error(get_s_connected_cmpts(invalid_graph))
  expect_error(get_selection(invalid_graph))
  expect_error(get_similar_nbrs(invalid_graph))
  expect_error(get_successors(invalid_graph))
  expect_error(get_w_connected_cmpts(invalid_graph))
  expect_error(invert_selection(invalid_graph))
  expect_error(is_graph_connected(invalid_graph))
  expect_error(is_graph_dag(invalid_graph))
  expect_error(is_graph_directed(invalid_graph))
  expect_error(is_graph_empty(invalid_graph))
  expect_error(is_graph_simple(invalid_graph))
  expect_error(is_graph_weighted(invalid_graph))
  expect_error(is_property_graph(invalid_graph))
  expect_error(join_edge_attrs(invalid_graph))
  expect_error(join_node_attrs(invalid_graph))
  expect_error(layout_nodes_w_string(invalid_graph))
  expect_error(mutate_edge_attrs(invalid_graph))
  expect_error(mutate_node_attrs(invalid_graph))
  expect_error(node_count(invalid_graph))
  expect_error(node_info(invalid_graph))
  expect_error(node_present(invalid_graph))
  expect_error(node_type(invalid_graph))
  expect_error(nudge_node_positions_ws(invalid_graph))
  expect_error(recode_edge_attrs(invalid_graph))
  expect_error(recode_node_attrs(invalid_graph))
  expect_error(rename_edge_attrs(invalid_graph))
  expect_error(rename_node_attrs(invalid_graph))
  expect_error(render_graph(invalid_graph))
  expect_error(reorder_graph_actions(invalid_graph))
  expect_error(rescale_edge_attrs(invalid_graph))
  expect_error(rescale_node_attrs(invalid_graph))
  expect_error(rev_edge_dir(invalid_graph))
  expect_error(rev_edge_dir_ws(invalid_graph))
  expect_error(select_edges(invalid_graph))
  expect_error(select_edges_by_edge_id(invalid_graph))
  expect_error(select_edges_by_node_id(invalid_graph))
  expect_error(select_last_edges_created(invalid_graph))
  expect_error(select_last_nodes_created(invalid_graph))
  expect_error(select_nodes(invalid_graph))
  expect_error(select_nodes_by_degree(invalid_graph))
  expect_error(select_nodes_by_id(invalid_graph))
  expect_error(select_nodes_in_neighborhood(invalid_graph))
  expect_error(trav_reverse_edge(invalid_graph))
  expect_error(trigger_graph_actions(invalid_graph))
  expect_error(set_cache(invalid_graph))
  expect_error(set_df_as_edge_attr(invalid_graph))
  expect_error(set_df_as_node_attr(invalid_graph))
  expect_error(set_edge_attrs(invalid_graph))
  expect_error(set_edge_attrs_ws(invalid_graph))
  expect_error(set_global_graph_attrs(invalid_graph))
  expect_error(set_graph_name(invalid_graph))
  expect_error(set_graph_time(invalid_graph))
  expect_error(set_graph_undirected(invalid_graph))
  expect_error(set_node_attr_to_display(invalid_graph))
  expect_error(set_node_attrs(invalid_graph))
  expect_error(set_node_attrs_ws(invalid_graph))
  expect_error(set_node_position(invalid_graph))
  expect_error(to_igraph(invalid_graph))
  expect_error(trav_both(invalid_graph))
  expect_error(trav_both_edge(invalid_graph))
  expect_error(trav_in(invalid_graph))
  expect_error(trav_in_edge(invalid_graph))
  expect_error(trav_in_node(invalid_graph))
  expect_error(trav_reverse_edge(invalid_graph))
  expect_error(trav_out(invalid_graph))
  expect_error(trav_out_edge(invalid_graph))
  expect_error(trav_out_node(invalid_graph))

  expect_error(combine_graphs(x = invalid_graph, y = valid_graph))
  expect_error(combine_graphs(x = valid_graph, y = invalid_graph))
})

test_that("Using an empty graph with trigger an error", {

  # Create an empty graph
  empty_graph <- create_graph()

  # Expect errors with all functions that check
  # for an empty graph
  expect_error(add_edge(empty_graph))
  expect_error(add_edge_df(empty_graph))
  expect_error(add_edges_from_table(empty_graph))
  expect_error(add_edges_w_string(empty_graph))
  expect_error(add_n_node_clones(empty_graph))
  expect_error(add_n_nodes_ws(empty_graph))
  expect_error(create_complement_graph(empty_graph))
  expect_error(delete_edge(empty_graph))
  expect_error(delete_edges_ws(empty_graph))
  expect_error(delete_node(empty_graph))
  expect_error(delete_nodes_ws(empty_graph))
  expect_error(do_bfs(empty_graph))
  expect_error(do_dfs(empty_graph))
  expect_error(get_attr_dfs(empty_graph))
  expect_error(get_degree_distribution(empty_graph))
  expect_error(get_degree_histogram(empty_graph))
  expect_error(get_eccentricity(empty_graph))
  expect_error(get_last_nodes_created(empty_graph))
  expect_error(nudge_node_positions_ws(empty_graph))
  expect_error(recode_node_attrs(empty_graph))
  expect_error(rename_node_attrs(empty_graph))
  expect_error(rescale_node_attrs(empty_graph))
  expect_error(select_edges(empty_graph))
  expect_error(select_last_nodes_created(empty_graph))
  expect_error(select_nodes(empty_graph))
  expect_error(select_nodes_by_degree(empty_graph))
  expect_error(select_nodes_by_id(empty_graph))
  expect_error(select_nodes_in_neighborhood(empty_graph))
  expect_error(set_df_as_node_attr(empty_graph))
  expect_error(set_node_attr_to_display(empty_graph))
  expect_error(set_node_attrs(empty_graph))
  expect_error(set_node_attrs_ws(empty_graph))
  expect_error(set_node_position(empty_graph))
  expect_error(trav_both(empty_graph))
  expect_error(trav_both_edge(empty_graph))
  expect_error(trav_in(empty_graph))
  expect_error(trav_in_edge(empty_graph))
  expect_error(trav_in_node(empty_graph))
  expect_error(trav_out(empty_graph))
  expect_error(trav_out_edge(empty_graph))
  expect_error(trav_out_node(empty_graph))
})

test_that("Using an graph with no edges with trigger an error", {

  # Create a graph with nodes but no edges
  graph_no_edges <-
    create_graph() %>%
    add_n_nodes(5)

  # Expect errors with all functions that check
  # for an empty graph
  expect_error(add_edge_clone(graph_no_edges))
  expect_error(add_forward_edges_ws(graph_no_edges))
  expect_error(add_reverse_edges_ws(graph_no_edges))
  expect_error(delete_edge(graph_no_edges))
  expect_error(delete_edges_ws(graph_no_edges))
  expect_error(get_edge_count_w_multiedge(graph_no_edges))
  expect_error(get_last_edges_created(graph_no_edges))
  expect_error(get_multiedge_count(graph_no_edges))
  expect_error(recode_edge_attrs(graph_no_edges))
  expect_error(rename_edge_attrs(graph_no_edges))
  expect_error(rescale_edge_attrs(graph_no_edges))
  expect_error(rev_edge_dir(graph_no_edges))
  expect_error(rev_edge_dir_ws(graph_no_edges))
  expect_error(select_edges(graph_no_edges))
  expect_error(select_edges_by_edge_id(graph_no_edges))
  expect_error(select_edges_by_node_id(graph_no_edges))
  expect_error(select_last_edges_created(graph_no_edges))
  expect_error(set_df_as_edge_attr(graph_no_edges))
  expect_error(set_edge_attrs_ws(graph_no_edges))
  expect_error(trav_both(graph_no_edges))
  expect_error(trav_both_edge(graph_no_edges))
  expect_error(trav_in(graph_no_edges))
  expect_error(trav_in_edge(graph_no_edges))
  expect_error(trav_in_node(graph_no_edges))
  expect_error(trav_out(graph_no_edges))
  expect_error(trav_out_edge(graph_no_edges))
  expect_error(trav_out_node(graph_no_edges))
  expect_error(trav_reverse_edge(graph_no_edges))
})
